/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.client.manametal;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import project.studio.manametalmod.core.IBiomeFogM3;
import project.studio.manametalmod.event.EventFog;

@Mixin(value={EventFog.class})
public abstract class MixinEventFog {
    @Shadow
    private static double fogX;
    @Shadow
    private static double fogZ;
    @Shadow
    private static boolean fogInit;
    @Shadow
    private static float fogFarPlaneDistance;
    @Unique
    private final BiomeGenBase[][] biomeCache = new BiomeGenBase[41][41];
    @Unique
    private int cacheOriginX = Integer.MAX_VALUE;
    @Unique
    private int cacheOriginZ = Integer.MAX_VALUE;

    @SubscribeEvent
    @Overwrite(remap=false)
    public void onRenderFog(EntityViewRenderEvent.RenderFogEvent event) {
        boolean isCacheInvalid;
        EntityLivingBase entity = event.entity;
        World world = entity.field_70170_p;
        int playerX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int playerY = MathHelper.func_76128_c((double)entity.field_70163_u);
        int playerZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        if ((double)playerX == fogX && (double)playerZ == fogZ && fogInit) {
            MixinEventFog.renderFog(event.fogMode, fogFarPlaneDistance, 0.75f);
            return;
        }
        int distance = 20;
        boolean bl = isCacheInvalid = playerX != this.cacheOriginX || playerZ != this.cacheOriginZ;
        if (isCacheInvalid) {
            this.cacheOriginX = playerX;
            this.cacheOriginZ = playerZ;
            for (int x = -20; x <= 20; ++x) {
                for (int z = -20; z <= 20; ++z) {
                    BiomeGenBase biome;
                    int cacheX = x + 20;
                    int cacheZ = z + 20;
                    this.biomeCache[cacheX][cacheZ] = biome = world.func_72807_a(playerX + x, playerZ + z);
                }
            }
        }
        fogInit = true;
        float fpDistanceBiomeFog = 0.0f;
        float weightBiomeFog = 0.0f;
        for (int x = -20; x <= 20; ++x) {
            for (int z = -20; z <= 20; ++z) {
                double zDiff;
                double xDiff;
                int cacheX = x + 20;
                int cacheZ = z + 20;
                BiomeGenBase biome = this.biomeCache[cacheX][cacheZ];
                if (!(biome instanceof IBiomeFogM3)) continue;
                float distancePart = ((IBiomeFogM3)biome).getFogDensity(playerX + x, playerY, playerZ + z);
                float weightPart = 1.0f;
                if (x == -20) {
                    xDiff = 1.0 - (entity.field_70165_t - (double)playerX);
                    distancePart = (float)((double)distancePart * xDiff);
                    weightPart = (float)((double)weightPart * xDiff);
                } else if (x == 20) {
                    xDiff = entity.field_70165_t - (double)playerX;
                    distancePart = (float)((double)distancePart * xDiff);
                    weightPart = (float)((double)weightPart * xDiff);
                }
                if (z == -20) {
                    zDiff = 1.0 - (entity.field_70161_v - (double)playerZ);
                    distancePart = (float)((double)distancePart * zDiff);
                    weightPart = (float)((double)weightPart * zDiff);
                } else if (z == 20) {
                    zDiff = entity.field_70161_v - (double)playerZ;
                    distancePart = (float)((double)distancePart * zDiff);
                    weightPart = (float)((double)weightPart * zDiff);
                }
                fpDistanceBiomeFog += distancePart;
                weightBiomeFog += weightPart;
            }
        }
        float weightMixed = 1600.0f;
        float weightDefault = weightMixed - weightBiomeFog;
        float fpDistanceBiomeFogAvg = weightBiomeFog == 0.0f ? 0.0f : fpDistanceBiomeFog / weightBiomeFog;
        float farPlaneDistance = (fpDistanceBiomeFog * 240.0f + event.farPlaneDistance * weightDefault) / weightMixed;
        float farPlaneDistanceScaleBiome = 0.1f * (1.0f - fpDistanceBiomeFogAvg) + 0.75f * fpDistanceBiomeFogAvg;
        float farPlaneDistanceScale = (farPlaneDistanceScaleBiome * weightBiomeFog + 0.75f * weightDefault) / weightMixed;
        fogX = entity.field_70165_t;
        fogZ = entity.field_70161_v;
        fogFarPlaneDistance = Math.min(farPlaneDistance, event.farPlaneDistance);
        MixinEventFog.renderFog(event.fogMode, fogFarPlaneDistance, farPlaneDistanceScale);
    }

    @Shadow
    private static void renderFog(int fogMode, float farPlaneDistance, float farPlaneDistanceScale) {
    }
}

