/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.buildcraft.addon.oiltweaks;

import buildcraft.oiltweak.BuildCraftOilTweak;
import buildcraft.oiltweak.OilTweakEventHandler;
import buildcraft.oiltweak.OilTweakProperties;
import buildcraft.oiltweak.api.OilTweakAPI;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fr.iamacat.optimizationsandtweaks.config.OptimizationsandTweaksConfig;
import fr.iamacat.optimizationsandtweaks.utilsformods.buildcraft.InOil2;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={OilTweakEventHandler.class})
public class MixinOilTweakEventHandler {
    @Unique
    private final Map<Block, Boolean> optimizationsAndTweaks$oilBlockCache = new HashMap<Block, Boolean>();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @Overwrite(remap=false)
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent e) {
        if (!BuildCraftOilTweak.config.isOilDense()) {
            return;
        }
        EntityLivingBase entity = e.entityLiving;
        if (this.optimizationsAndTweaks$getInOil((Entity)entity).halfOfFull()) {
            entity.field_70181_x = Math.min(0.0, entity.field_70181_x);
            if (entity.field_70181_x < -0.05) {
                entity.field_70181_x *= 0.05;
            }
            entity.field_70159_w = Math.max(-0.05, Math.min(0.05, entity.field_70159_w * 0.05));
            entity.field_70181_x -= 0.05;
            entity.field_70179_y = Math.max(-0.05, Math.min(0.05, entity.field_70179_y * 0.05));
            this.setStepHeight(entity, 0.0f);
        } else {
            this.setNotInOil(entity);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @Overwrite(remap=false)
    public void onPlayerUpdate(TickEvent.PlayerTickEvent e) {
        if (!BuildCraftOilTweak.config.isOilDense()) {
            return;
        }
        EntityPlayer player = e.player;
        if (!this.optimizationsAndTweaks$getInOil((Entity)player).halfOfFull()) {
            this.setNotInOil((EntityLivingBase)player);
            return;
        }
        player.field_70181_x = Math.min(0.0, player.field_70181_x);
        if (player.field_70181_x < -0.05) {
            player.field_70181_x *= 0.05;
        }
        player.field_70159_w = Math.max(-0.05, Math.min(0.05, player.field_70159_w * 0.05));
        player.field_70181_x -= 0.05;
        player.field_70179_y = Math.max(-0.05, Math.min(0.05, player.field_70179_y * 0.05));
        player.field_71075_bZ.field_75100_b = player.field_71075_bZ.field_75100_b && player.field_71075_bZ.field_75098_d;
        this.setStepHeight((EntityLivingBase)player, 0.0f);
    }

    @Overwrite(remap=false)
    @SideOnly(value=Side.CLIENT)
    public void onPlayerClientUpdate(TickEvent.ClientTickEvent e) {
        if (OptimizationsandTweaksConfig.enableMixinOilTweakEventHandler) {
            if (!BuildCraftOilTweak.config.isOilDense()) {
                return;
            }
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            if (!this.optimizationsAndTweaks$getInOil((Entity)player).halfOfFull()) {
                this.setNotInOil((EntityLivingBase)player);
                return;
            }
            player.field_70181_x = Math.min(0.0, player.field_70181_x);
            if (player.field_70181_x < -0.05) {
                player.field_70181_x *= 0.05;
            }
            player.field_70159_w = Math.max(-0.05, Math.min(0.05, player.field_70159_w * 0.05));
            player.field_70181_x -= 0.05;
            player.field_70179_y = Math.max(-0.05, Math.min(0.05, player.field_70179_y * 0.05));
            player.field_71075_bZ.field_75100_b = player.field_71075_bZ.field_75100_b && player.field_71075_bZ.field_75098_d;
            this.setStepHeight((EntityLivingBase)player, 0.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @Overwrite(remap=false)
    public void onBreakSpeed(PlayerEvent.BreakSpeed e) {
        if (OptimizationsandTweaksConfig.enableMixinOilTweakEventHandler) {
            if (!BuildCraftOilTweak.config.isOilDense()) {
                return;
            }
            EntityPlayer player = e.entityPlayer;
            if (this.optimizationsAndTweaks$getInOil((Entity)player).halfOfFull()) {
                e.newSpeed = e.originalSpeed <= e.newSpeed ? e.originalSpeed / 3.0f : e.newSpeed / 3.0f;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @Overwrite(remap=false)
    public void onTeleportAttempt(EnderTeleportEvent e) {
        if (OptimizationsandTweaksConfig.enableMixinOilTweakEventHandler) {
            if (!BuildCraftOilTweak.config.isOilDense()) {
                return;
            }
            EntityLivingBase player = e.entityLiving;
            if (!(player instanceof EntityPlayer && ((EntityPlayer)player).field_71075_bZ.field_75098_d || !this.optimizationsAndTweaks$getInOil((Entity)player).halfOfFull())) {
                e.setCanceled(true);
                e.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @Overwrite(remap=false)
    public void onRightClick(PlayerInteractEvent e) {
        InOil2 inOil;
        if (e.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK || !BuildCraftOilTweak.config.isOilDense()) {
            return;
        }
        EntityPlayer player = e.entityPlayer;
        if (!player.field_71075_bZ.field_75098_d && player.func_71045_bC() != null && (inOil = this.optimizationsAndTweaks$getInOil((Entity)player)).halfOfFull() && (inOil == InOil2.FULL && !(player.func_71045_bC().func_77973_b() instanceof ItemBlock) || OilTweakAPI.INSTANCE.getItemBlacklistRegistry().isBlacklisted((EntityLivingBase)player, player.func_71045_bC()))) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation(inOil == InOil2.FULL ? "oiltweak.chat.tooDense.use" : "oiltweak.chat.tooDense.use.half", new Object[0]));
            e.setCanceled(true);
        }
    }

    @Unique
    protected InOil2 optimizationsAndTweaks$getInOil(Entity entity) {
        AxisAlignedBB boundingBox = entity.field_70121_D;
        int minX = MathHelper.func_76128_c((double)boundingBox.field_72340_a);
        int minY = MathHelper.func_76128_c((double)boundingBox.field_72338_b);
        int minZ = MathHelper.func_76128_c((double)boundingBox.field_72339_c);
        int maxX = MathHelper.func_76128_c((double)boundingBox.field_72336_d);
        int maxY = MathHelper.func_76128_c((double)boundingBox.field_72337_e);
        int maxZ = MathHelper.func_76128_c((double)boundingBox.field_72334_f);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    Block block = entity.field_70170_p.func_147439_a(x, y, z);
                    if (!this.isOil(block)) continue;
                    Block blockAtMaxY = entity.field_70170_p.func_147439_a(x, maxY, z);
                    return maxY == minY || this.isOil(blockAtMaxY) ? InOil2.FULL : InOil2.HALF;
                }
            }
        }
        return InOil2.NONE;
    }

    @Shadow
    private void setStepHeight(EntityLivingBase entity, float height) {
        OilTweakProperties props = this.getProperties(entity);
        if (!props.inOil) {
            props.realStepHeight = entity.field_70138_W;
            props.inOil = true;
        }
        entity.field_70138_W = height;
    }

    @Shadow
    private OilTweakProperties getProperties(EntityLivingBase entity) {
        IExtendedEntityProperties ieep = entity.getExtendedProperties("oiltweak");
        if (!(ieep instanceof OilTweakProperties)) {
            ieep = new OilTweakProperties();
            ieep.init((Entity)entity, entity.field_70170_p);
            entity.registerExtendedProperties("oiltweak", ieep);
        }
        return (OilTweakProperties)ieep;
    }

    @Overwrite(remap=false)
    private void setNotInOil(EntityLivingBase entity) {
        OilTweakProperties props = this.getProperties(entity);
        if (props.inOil) {
            entity.field_70138_W = props.realStepHeight;
            props.inOil = false;
        }
    }

    @Overwrite(remap=false)
    private boolean isOil(Block block) {
        Fluid fluid;
        Boolean cachedValue = this.optimizationsAndTweaks$oilBlockCache.get(block);
        if (cachedValue != null) {
            return cachedValue;
        }
        boolean isOilBlock = false;
        if (block != null && block != Blocks.field_150350_a && FluidRegistry.isFluidRegistered((Fluid)(fluid = FluidRegistry.lookupFluidForBlock((Block)block))) && fluid.getName() != null && fluid.getName().equalsIgnoreCase("oil")) {
            isOilBlock = true;
        }
        this.optimizationsAndTweaks$oilBlockCache.put(block, isOilBlock);
        return isOilBlock;
    }
}

