/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.codechickencore;

import codechicken.core.ClassDiscoverer;
import codechicken.core.CommonUtils;
import codechicken.core.IStringMatcher;
import codechicken.core.launch.CodeChickenCorePlugin;
import codechicken.lib.asm.ASMHelper;
import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModClassLoader;
import cpw.mods.fml.relauncher.CoreModManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ClassDiscoverer.class})
public class MixinClassDiscoverer {
    @Shadow
    public IStringMatcher matcher;
    @Shadow
    public String[] superclasses;
    @Shadow
    public ArrayList<Class<?>> classes;
    @Shadow
    public ModClassLoader modClassLoader;

    public MixinClassDiscoverer(IStringMatcher matcher, Class<?> ... superclasses) {
        this.matcher = matcher;
        this.superclasses = new String[superclasses.length];
        for (int i = 0; i < superclasses.length; ++i) {
            this.superclasses[i] = superclasses[i].getName().replace('.', '/');
        }
        this.classes = new ArrayList();
        this.modClassLoader = (ModClassLoader)Loader.instance().getModClassLoader();
    }

    public MixinClassDiscoverer(Class<?> ... superclasses) {
        this(new IStringMatcher(){

            public boolean matches(String test) {
                return true;
            }
        }, superclasses);
    }

    @Overwrite(remap=false)
    public ArrayList<Class<?>> findClasses() {
        try {
            this.findClasspathMods();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.classes;
    }

    @Overwrite(remap=false)
    private void checkAddClass(String resource) {
        try {
            String classname = resource.replace(".class", "").replace("\\", ".").replace("/", ".");
            byte[] bytes = Launch.classLoader.getClassBytes(classname);
            if (bytes == null) {
                return;
            }
            ClassNode cnode = ASMHelper.createClassNode((byte[])bytes);
            for (String superclass : this.superclasses) {
                if (cnode.interfaces.contains(superclass) || cnode.superName.equals(superclass)) continue;
                return;
            }
            this.addClass(classname);
        }
        catch (IOException e) {
            CodeChickenCorePlugin.logger.error("Unable to load class: " + resource, (Throwable)e);
        }
    }

    @Overwrite(remap=false)
    private void addClass(String classname) {
        try {
            Class<?> class1 = Class.forName(classname, true, (ClassLoader)this.modClassLoader);
            this.classes.add(class1);
        }
        catch (Throwable t) {
            CodeChickenCorePlugin.logger.error("Unable to load class: " + classname, t);
        }
    }

    @Overwrite(remap=false)
    private void findClasspathMods() {
        ImmutableList knownLibraries = ImmutableList.builder().addAll((Iterable)this.modClassLoader.getDefaultLibraries()).addAll((Iterable)CoreModManager.getLoadedCoremods()).build();
        File[] minecraftSources = this.modClassLoader.getParentSources();
        HashSet<String> searchedSources = new HashSet<String>();
        for (File minecraftSource : minecraftSources) {
            if (searchedSources.contains(minecraftSource.getAbsolutePath())) continue;
            searchedSources.add(minecraftSource.getAbsolutePath());
            if (minecraftSource.isFile()) {
                if (knownLibraries.contains(minecraftSource.getName())) continue;
                FMLLog.fine((String)"Found a minecraft related file at %s, examining for codechicken classes", (Object[])new Object[]{minecraftSource.getAbsolutePath()});
                try {
                    this.readFromZipFile(minecraftSource);
                }
                catch (Exception e) {
                    CodeChickenCorePlugin.logger.error("Failed to scan " + minecraftSource.getAbsolutePath() + ", the zip file is invalid", (Throwable)e);
                }
                continue;
            }
            if (!minecraftSource.isDirectory()) continue;
            FMLLog.fine((String)"Found a minecraft related directory at %s, examining for codechicken classes", (Object[])new Object[]{minecraftSource.getAbsolutePath()});
            this.readFromDirectory(minecraftSource, minecraftSource);
        }
    }

    @Overwrite(remap=false)
    private void readFromZipFile(File file) throws IOException {
        try (FileInputStream fileinputstream = new FileInputStream(file);
             ZipInputStream zipinputstream = new ZipInputStream(fileinputstream);){
            ZipEntry zipentry;
            while ((zipentry = zipinputstream.getNextEntry()) != null) {
                String name;
                String fullname = zipentry.getName().replace('\\', '/');
                int pos = fullname.lastIndexOf(47);
                String string = name = pos == -1 ? fullname : fullname.substring(pos + 1);
                if (!zipentry.isDirectory() && this.matcher.matches(name)) {
                    this.checkAddClass(fullname);
                }
                zipinputstream.closeEntry();
            }
        }
    }

    @Overwrite(remap=false)
    private void readFromDirectory(File directory, File basedirectory) {
        for (File child : Objects.requireNonNull(directory.listFiles())) {
            if (child.isDirectory()) {
                this.readFromDirectory(child, basedirectory);
                continue;
            }
            if (!child.isFile() || !this.matcher.matches(child.getName())) continue;
            String fullname = CommonUtils.getRelativePath((File)basedirectory, (File)child);
            this.checkAddClass(fullname);
        }
    }
}

