/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.core;

import cpw.mods.fml.common.FMLLog;
import fr.iamacat.optimizationsandtweaks.utils.natives.AsyncPathfindingExecutor;
import fr.iamacat.optimizationsandtweaks.utils.pathfinding.CachedPath;
import fr.iamacat.optimizationsandtweaks.utils.pathfinding.PendingPathRequest;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.world.IBlockAccess;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PathFinder.class})
public abstract class MixinPathFinder {
    @Shadow
    private IBlockAccess field_75868_a;
    @Shadow
    private boolean field_75865_e;
    @Shadow
    private boolean field_75862_f;
    @Shadow
    private boolean field_75863_g;
    @Shadow
    private boolean field_75869_h;
    @Unique
    private static boolean optimizationsAndTweaks$asyncPathfindingEnabled = false;
    @Unique
    private static boolean optimizationsAndTweaks$asyncPathfindingChecked = false;
    @Unique
    private static final Map<Integer, PendingPathRequest> optimizationsAndTweaks$pendingPaths = new ConcurrentHashMap<Integer, PendingPathRequest>();
    @Unique
    private static final Map<Integer, CachedPath> optimizationsAndTweaks$cachedPaths = new ConcurrentHashMap<Integer, CachedPath>();

    @Unique
    private static void optimizationsAndTweaks$checkAsyncPathfinding() {
        optimizationsAndTweaks$asyncPathfindingEnabled = AsyncPathfindingExecutor.isInitialized();
        if (!optimizationsAndTweaks$asyncPathfindingEnabled) {
            AsyncPathfindingExecutor.initializeAuto();
            optimizationsAndTweaks$asyncPathfindingEnabled = AsyncPathfindingExecutor.isInitialized();
        }
    }

    @Inject(method={"createEntityPathTo(Lnet/minecraft/entity/Entity;Lnet/minecraft/entity/Entity;F)Lnet/minecraft/pathfinding/PathEntity;"}, at={@At(value="HEAD")}, cancellable=true)
    private void optimizationsAndTweaks$createEntityPathToEntity(Entity entity, Entity target, float maxDistance, CallbackInfoReturnable<PathEntity> cir) {
        MixinPathFinder.optimizationsAndTweaks$checkAsyncPathfinding();
        if (!optimizationsAndTweaks$asyncPathfindingEnabled) {
            return;
        }
        try {
            PathEntity path = this.optimizationsAndTweaks$getOrRequestPath(entity, target.field_70165_t, target.field_70121_D.field_72338_b, target.field_70161_v, maxDistance);
            if (path != null) {
                cir.setReturnValue((Object)path);
            } else {
                cir.setReturnValue(null);
            }
        }
        catch (Exception e) {
            FMLLog.warning((String)"[OptimizationsAndTweaks] Async pathfinding failed, falling back to vanilla: %s", (Object[])new Object[]{e.getMessage()});
        }
    }

    @Inject(method={"createEntityPathTo(Lnet/minecraft/entity/Entity;IIIF)Lnet/minecraft/pathfinding/PathEntity;"}, at={@At(value="HEAD")}, cancellable=true)
    private void optimizationsAndTweaks$createEntityPathToCoords(Entity entity, int x, int y, int z, float maxDistance, CallbackInfoReturnable<PathEntity> cir) {
        MixinPathFinder.optimizationsAndTweaks$checkAsyncPathfinding();
        if (!optimizationsAndTweaks$asyncPathfindingEnabled) {
            return;
        }
        try {
            PathEntity path = this.optimizationsAndTweaks$getOrRequestPath(entity, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, maxDistance);
            if (path != null) {
                cir.setReturnValue((Object)path);
            } else {
                cir.setReturnValue(null);
            }
        }
        catch (Exception e) {
            FMLLog.warning((String)"[OptimizationsAndTweaks] Async pathfinding failed, falling back to vanilla: %s", (Object[])new Object[]{e.getMessage()});
        }
    }

    @Unique
    private PathEntity optimizationsAndTweaks$getOrRequestPath(Entity entity, double targetX, double targetY, double targetZ, float maxDistance) {
        int entityId = entity.func_145782_y();
        long currentTime = System.currentTimeMillis();
        CachedPath cached = optimizationsAndTweaks$cachedPaths.get(entityId);
        if (cached != null && cached.isValid(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, targetX, targetY, targetZ, currentTime)) {
            return cached.getPath();
        }
        PendingPathRequest pending = optimizationsAndTweaks$pendingPaths.get(entityId);
        if (pending != null && pending.isStillValid(targetX, targetY, targetZ, currentTime)) {
            return null;
        }
        long requestId = AsyncPathfindingExecutor.submitPathfindingWithCallback(this.field_75868_a, entity, targetX, targetY, targetZ, maxDistance, path -> {
            optimizationsAndTweaks$cachedPaths.put(entityId, new CachedPath((PathEntity)path, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, targetX, targetY, targetZ, System.currentTimeMillis()));
            optimizationsAndTweaks$pendingPaths.remove(entityId);
            try {
                if (entity instanceof EntityLiving && path != null) {
                    ((EntityLiving)entity).func_70661_as().func_75484_a(path, 1.0);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, error -> optimizationsAndTweaks$pendingPaths.remove(entityId), this.field_75865_e, this.field_75862_f, this.field_75863_g, this.field_75869_h);
        if (requestId != 0L) {
            optimizationsAndTweaks$pendingPaths.put(entityId, new PendingPathRequest(requestId, targetX, targetY, targetZ, currentTime));
        }
        return null;
    }
}

