/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.thecampingmod;

import com.rikmuld.camping.common.world.WorldGenerator;
import com.rikmuld.camping.core.Objs$;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={WorldGenerator.class})
public abstract class MixinWorldGeneratorTheCamping {
    @Shadow(remap=false)
    public abstract void xBlock_$eq(int var1);

    @Shadow(remap=false)
    public abstract void yBlock_$eq(int var1);

    @Shadow(remap=false)
    public abstract void zBlock_$eq(int var1);

    @Overwrite(remap=false)
    public void generateSurface(World world, Random random, int blockX, int blockZ) {
        if (Objs$.MODULE$.config().worldGenHemp()) {
            int hempMulti = Math.max(1, Objs$.MODULE$.config().hempGenMulti());
            for (int i = 0; i < hempMulti; ++i) {
                this.optimizationsAndTweaks$generateHemp(world, random, blockX, blockZ);
            }
        }
        this.optimizationsAndTweaks$generateCampsite(world, random, blockX, blockZ);
    }

    @Unique
    private void optimizationsAndTweaks$generateHemp(World world, Random random, int blockX, int blockZ) {
        int x = blockX + random.nextInt(16);
        int y = random.nextInt(15) + 55;
        int z = blockZ + random.nextInt(16);
        if (!MixinWorldGeneratorTheCamping.optimizationsAndTweaks$isChunkLoaded(world, x, z)) {
            return;
        }
        this.xBlock_$eq(x);
        this.yBlock_$eq(y);
        this.zBlock_$eq(z);
        for (int i = 0; i < 20 && this.optimizationsAndTweaks$generateSingleHemp(world, random, x, y, z); ++i) {
        }
    }

    @Unique
    private void optimizationsAndTweaks$generateCampsite(World world, Random random, int blockX, int blockZ) {
        int checkZ;
        if (Objs$.MODULE$.config().coreOnly()) {
            return;
        }
        BiomeGenBase biome = world.func_72807_a(blockX, blockZ);
        if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            return;
        }
        int checkX = blockX + random.nextInt(16);
        if (!MixinWorldGeneratorTheCamping.optimizationsAndTweaks$isChunkLoaded(world, checkX, checkZ = blockZ + random.nextInt(16))) {
            return;
        }
        BiomeGenBase.TempCategory tempCategory = world.func_72807_a(checkX, checkZ).func_150561_m();
        if (tempCategory != BiomeGenBase.TempCategory.MEDIUM) {
            return;
        }
        if (random.nextInt(Objs$.MODULE$.config().campsiteRareness()) == 0 && Objs$.MODULE$.config().worldGenCampsite()) {
            this.xBlock_$eq(checkX);
            this.yBlock_$eq(50);
            this.zBlock_$eq(checkZ);
            this.optimizationsAndTweaks$generateCampsiteStructure(world, random, checkX, 50, checkZ);
        }
    }

    @Unique
    private void optimizationsAndTweaks$generateCampsiteStructure(World world, Random rand, int x, int yCoord, int z) {
        int y = yCoord;
        do {
            if (!MixinWorldGeneratorTheCamping.optimizationsAndTweaks$isChunkLoaded(world, x, z)) {
                return;
            }
            if (!world.func_72899_e(x, y + 1, z) || !world.func_72899_e(x, y + 2, z)) {
                return;
            }
            if (!world.func_147437_c(x, y + 1, z) || !world.func_147437_c(x, y + 2, z)) continue;
            if (this.optimizationsAndTweaks$isValidCampsiteLocation(world, x, y, z)) {
                this.optimizationsAndTweaks$placeCampsite(world, rand, x, y, z);
                return;
            }
            return;
        } while (++y <= yCoord + 20);
    }

    @Unique
    private boolean optimizationsAndTweaks$isValidCampsiteLocation(World world, int x, int y, int z) {
        if (!(MixinWorldGeneratorTheCamping.optimizationsAndTweaks$isChunkLoaded(world, x - 1, z) && MixinWorldGeneratorTheCamping.optimizationsAndTweaks$isChunkLoaded(world, x - 1, z + 2) && MixinWorldGeneratorTheCamping.optimizationsAndTweaks$isChunkLoaded(world, x + 4, z) && MixinWorldGeneratorTheCamping.optimizationsAndTweaks$isChunkLoaded(world, x + 4, z + 2))) {
            return false;
        }
        if (!(this.optimizationsAndTweaks$locationIsValidSpawn(world, x - 1, y, z) && this.optimizationsAndTweaks$locationIsValidSpawn(world, x - 1, y, z + 2) && this.optimizationsAndTweaks$locationIsValidSpawn(world, x + 4, y, z + 2) && this.optimizationsAndTweaks$locationIsValidSpawn(world, x + 4, y, z))) {
            return false;
        }
        return this.optimizationsAndTweaks$isValidSpawnArea(world, x, y, z, 6, 3);
    }

    @Unique
    private boolean optimizationsAndTweaks$locationIsValidSpawn(World world, int x, int y, int z) {
        if (!world.func_72899_e(x, y, z)) {
            return false;
        }
        return world.func_147439_a(x, y, z) == Blocks.field_150349_c;
    }

    @Unique
    private boolean optimizationsAndTweaks$isValidSpawnArea(World world, int x, int y, int z, int xLength, int zLength) {
        for (int i = 0; i < xLength; ++i) {
            for (int j = 0; j < zLength; ++j) {
                int checkX = x + i;
                int checkZ = z + j;
                if (!MixinWorldGeneratorTheCamping.optimizationsAndTweaks$isChunkLoaded(world, checkX, checkZ)) {
                    return false;
                }
                if (!world.func_72899_e(checkX, y + 1, checkZ)) {
                    return false;
                }
                if (world.func_147437_c(checkX, y + 1, checkZ)) continue;
                return false;
            }
        }
        return true;
    }

    @Unique
    private void optimizationsAndTweaks$placeCampsite(World world, Random rand, int x, int y, int z) {
        if (world.func_72899_e(x, y + 1, z + 1)) {
            world.func_147465_d(x, y + 1, z + 1, Objs$.MODULE$.campfire(), 0, 2);
        }
        if (world.func_72899_e(x + 2, y + 1, z + 1)) {
            world.func_147465_d(x + 2, y + 1, z + 1, Objs$.MODULE$.tent(), 2, 2);
            this.optimizationsAndTweaks$configureTentTileEntity(world, x + 2, y + 1, z + 1);
        }
        this.optimizationsAndTweaks$spawnCamper(world, x, y + 1, z);
    }

    @Unique
    private void optimizationsAndTweaks$configureTentTileEntity(World world, int x, int y, int z) {
        try {
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity != null) {
                Method setRotation = tileEntity.getClass().getMethod("setRotation", Integer.TYPE);
                setRotation.invoke((Object)tileEntity, 3);
                Class<?> tileEntityTentClass = Class.forName("com.rikmuld.camping.common.objs.tile.TileEntityTent$");
                Object module = tileEntityTentClass.getField("MODULE$").get(null);
                Method bedsMethod = tileEntityTentClass.getMethod("BEDS", new Class[0]);
                Object beds = bedsMethod.invoke(module, new Object[0]);
                Method setContends = tileEntity.getClass().getMethod("setContends", Integer.TYPE, Object.class, Boolean.TYPE, Integer.TYPE);
                setContends.invoke((Object)tileEntity, 1, beds, true, 0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Unique
    private void optimizationsAndTweaks$spawnCamper(World world, int x, int y, int z) {
        try {
            Class<?> camperClass = Class.forName("com.rikmuld.camping.common.objs.entity.Camper");
            Constructor<?> constructor = camperClass.getConstructor(World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Entity camper = (Entity)constructor.newInstance(world, x, y, z);
            world.func_72838_d(camper);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Unique
    private boolean optimizationsAndTweaks$generateSingleHemp(World world, Random random, int baseX, int baseY, int baseZ) {
        int targetZ;
        int targetX = baseX + random.nextInt(4) - random.nextInt(4);
        if (!MixinWorldGeneratorTheCamping.optimizationsAndTweaks$isChunkLoaded(world, targetX, targetZ = baseZ + random.nextInt(4) - random.nextInt(4))) {
            return false;
        }
        if (!world.func_147437_c(targetX, baseY, targetZ)) {
            return true;
        }
        if (!this.optimizationsAndTweaks$hasAdjacentWater(world, targetX, baseY, targetZ)) {
            return true;
        }
        int growthStage = random.nextInt(random.nextInt(4) + 1);
        if (!Objs$.MODULE$.hemp().func_149718_j(world, targetX, baseY, targetZ)) {
            return true;
        }
        if (world.func_72899_e(targetX, baseY, targetZ)) {
            world.func_147465_d(targetX, baseY, targetZ, Objs$.MODULE$.hemp(), growthStage, 2);
            if (growthStage == 4 && world.func_72899_e(targetX, baseY + 1, targetZ)) {
                world.func_147465_d(targetX, baseY + 1, targetZ, Objs$.MODULE$.hemp(), 5, 2);
            }
        }
        return true;
    }

    @Unique
    private boolean optimizationsAndTweaks$hasAdjacentWater(World world, int x, int y, int z) {
        return this.optimizationsAndTweaks$checkWaterBlock(world, x - 1, y - 1, z) || this.optimizationsAndTweaks$checkWaterBlock(world, x + 1, y - 1, z) || this.optimizationsAndTweaks$checkWaterBlock(world, x, y - 1, z - 1) || this.optimizationsAndTweaks$checkWaterBlock(world, x, y - 1, z + 1);
    }

    @Unique
    private boolean optimizationsAndTweaks$checkWaterBlock(World world, int x, int y, int z) {
        if (!world.func_72899_e(x, y, z)) {
            return false;
        }
        return world.func_147439_a(x, y, z).func_149688_o() == Material.field_151586_h;
    }

    @Unique
    private static boolean optimizationsAndTweaks$isChunkLoaded(World world, int x, int z) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        return world.func_72863_F().func_73149_a(chunkX, chunkZ);
    }
}

