/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.natives;

import cpw.mods.fml.common.FMLLog;
import fr.iamacat.optimizationsandtweaks.utils.natives.RustFFI;

public class RustPathfinding {
    private static boolean available = false;

    private static native long createPathFinder(boolean var0, boolean var1, boolean var2, boolean var3);

    private static native void destroyPathEntity(long var0);

    private static native int pathEntityGetCurrentIndex(long var0);

    private static native void pathEntitySetCurrentIndex(long var0, int var2);

    private static native int pathEntityGetLength(long var0);

    private static native boolean pathEntityIsFinished(long var0);

    private static native int[] pathEntityGetPoint(long var0, int var2);

    private static native int[] pathEntityGetAllPoints(long var0);

    public static native long findPathDirect(long var0, Object var2, double var3, double var5, double var7, double var9, double var11, double var13, float var15, float var16, float var17, boolean var18, int var19);

    public static long findPathDirectWorld(long pathfinderHandle, Object worldAdapter, double entityX, double entityY, double entityZ, double targetX, double targetY, double targetZ, float entityWidth, float entityHeight, float maxDistance, boolean isInWater, int maxSafePointTries) {
        return RustPathfinding.findPathDirect(pathfinderHandle, worldAdapter, entityX, entityY, entityZ, targetX, targetY, targetZ, entityWidth, entityHeight, maxDistance, isInWater, maxSafePointTries);
    }

    public static native long[] findPathBatch(long[] var0, int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, byte[][] var7, long[] var8, long[] var9, long[] var10, long[] var11, long[] var12, long[] var13, int[] var14, int[] var15, int[] var16, int[] var17, int[] var18);

    public static native void setProfilerEnabled(boolean var0);

    public static native boolean isProfilerEnabled();

    public static native void clearProfilerStats();

    public static native void initAsyncExecutor(int var0, int var1);

    public static native long submitAsyncPathfinding(long var0, int var2, boolean var3, boolean var4, boolean var5, boolean var6, int var7, int var8, int var9, int var10, int var11, int var12, byte[] var13, double var14, double var16, double var18, double var20, double var22, double var24, float var26, float var27, float var28, boolean var29, int var30);

    public static native long tryRecvAsyncResult(int[] var0);

    public static native int[] getAsyncExecutorStats();

    public static native void shutdownAsyncExecutor();

    public static boolean isAvailable() {
        return available && RustFFI.isInitialized();
    }

    public static void initialize() {
        if (!RustFFI.isInitialized()) {
            FMLLog.info((String)"[OptimizationsAndTweaks] Cannot initialize Rust pathfinding - RustFFI not initialized", (Object[])new Object[0]);
            return;
        }
        available = true;
    }

    public static class PathEntityHandle
    implements AutoCloseable {
        private long handle;
        private boolean closed = false;

        public PathEntityHandle(long handle) {
            this.handle = handle;
        }

        public long getHandle() {
            if (this.closed) {
                throw new IllegalStateException("PathEntity has been closed");
            }
            return this.handle;
        }

        public int getCurrentIndex() {
            return RustPathfinding.pathEntityGetCurrentIndex(this.getHandle());
        }

        public void setCurrentIndex(int index) {
            RustPathfinding.pathEntitySetCurrentIndex(this.getHandle(), index);
        }

        public int getLength() {
            return RustPathfinding.pathEntityGetLength(this.getHandle());
        }

        public boolean isFinished() {
            return RustPathfinding.pathEntityIsFinished(this.getHandle());
        }

        public int[] getPoint(int index) {
            return RustPathfinding.pathEntityGetPoint(this.getHandle(), index);
        }

        public int[] getAllPoints() {
            return RustPathfinding.pathEntityGetAllPoints(this.getHandle());
        }

        @Override
        public void close() {
            if (!this.closed) {
                RustPathfinding.destroyPathEntity(this.handle);
                this.closed = true;
            }
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    public static class PathFinderHandle
    implements AutoCloseable {
        private long handle;
        private boolean closed = false;

        public PathFinderHandle(boolean isWoodenDoorAllowed, boolean isMovementBlockAllowed, boolean isPathingInWater, boolean canEntityDrown) {
            if (!RustPathfinding.isAvailable()) {
                throw new IllegalStateException("Rust pathfinding is not available");
            }
            this.handle = RustPathfinding.createPathFinder(isWoodenDoorAllowed, isMovementBlockAllowed, isPathingInWater, canEntityDrown);
        }

        public long getHandle() {
            if (this.closed) {
                throw new IllegalStateException("PathFinder has been closed");
            }
            return this.handle;
        }

        @Override
        public void close() {
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }
}

