/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.natives;

import fr.iamacat.optimizationsandtweaks.utils.natives.RustPathfinding;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.world.IBlockAccess;

public class RustPathfindingBridge {
    private static final Map<Integer, PathFinderEntry> PATHFINDER_CACHE = new ConcurrentHashMap<Integer, PathFinderEntry>();

    private static RustPathfinding.PathFinderHandle getOrCreatePathFinder(Entity entity, boolean isWoodenDoorAllowed, boolean isMovementBlockAllowed, boolean isPathingInWater, boolean canEntityDrown) {
        int key = entity.func_145782_y();
        PathFinderEntry entry = PATHFINDER_CACHE.get(key);
        if (entry != null) {
            if (entry.woodenDoorAllowed == isWoodenDoorAllowed && entry.movementBlockAllowed == isMovementBlockAllowed && entry.pathingInWater == isPathingInWater && entry.canEntityDrown == canEntityDrown) {
                return entry.handle;
            }
            try {
                entry.handle.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        RustPathfinding.PathFinderHandle newHandle = new RustPathfinding.PathFinderHandle(isWoodenDoorAllowed, isMovementBlockAllowed, isPathingInWater, canEntityDrown);
        PATHFINDER_CACHE.put(key, new PathFinderEntry(newHandle, isWoodenDoorAllowed, isMovementBlockAllowed, isPathingInWater, canEntityDrown));
        return newHandle;
    }

    public static PathEntity findPathDirect(IBlockAccess world, Entity entity, double targetX, double targetY, double targetZ, float maxDistance, boolean isWoodenDoorAllowed, boolean isMovementBlockAllowed, boolean isPathingInWater, boolean canEntityDrown) {
        PathPoint[] points;
        float height;
        float width;
        WorldAccessAdapter adapter;
        if (!RustPathfinding.isAvailable()) {
            return null;
        }
        RustPathfinding.PathFinderHandle handleObj = RustPathfindingBridge.getOrCreatePathFinder(entity, isWoodenDoorAllowed, isMovementBlockAllowed, isPathingInWater, canEntityDrown);
        long handle = handleObj.getHandle();
        long pathEntityHandle = RustPathfinding.findPathDirectWorld(handle, adapter = new WorldAccessAdapter(world), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, targetX, targetY, targetZ, width = entity.field_70130_N, height = entity.field_70131_O, maxDistance, entity.func_70090_H(), entity.func_82143_as());
        if (pathEntityHandle == 0L) {
            return null;
        }
        try (RustPathfinding.PathEntityHandle rustPath = new RustPathfinding.PathEntityHandle(pathEntityHandle);){
            int[] allPoints = rustPath.getAllPoints();
            if (allPoints == null || allPoints.length == 0) {
                PathEntity pathEntity = null;
                return pathEntity;
            }
            int numPoints = allPoints.length / 3;
            points = new PathPoint[numPoints];
            for (int i = 0; i < numPoints; ++i) {
                int x = allPoints[i * 3];
                int y = allPoints[i * 3 + 1];
                int z = allPoints[i * 3 + 2];
                points[i] = new PathPoint(x, y, z);
            }
        }
        return new PathEntity(points);
    }

    public static byte[] encodeBlockCache(IBlockAccess world, int offsetX, int offsetY, int offsetZ, int width, int height, int depth) {
        byte[] cache = new byte[width * height * depth];
        int index = 0;
        for (int y = 0; y < height; ++y) {
            for (int z = 0; z < depth; ++z) {
                for (int x = 0; x < width; ++x) {
                    int worldX = offsetX + x;
                    int worldY = offsetY + y;
                    int worldZ = offsetZ + z;
                    cache[index++] = RustPathfindingBridge.encodeBlock(world, worldX, worldY, worldZ);
                }
            }
        }
        return cache;
    }

    /*
     * Loose catch block
     */
    private static byte encodeBlock(IBlockAccess world, int x, int y, int z) {
        Block b;
        block24: {
            b = world.func_147439_a(x, y, z);
            int id = Block.func_149682_b((Block)b);
            int meta = 0;
            try {
                meta = world.func_72805_g(x, y, z);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (id == 0) {
                return 0;
            }
            if (id == 8 || id == 9) {
                return 2;
            }
            if (id == 10 || id == 11) {
                return 3;
            }
            if (id == 64 || id == 71) {
                int m = meta;
                if ((m & 8) != 0) {
                    try {
                        m = world.func_72805_g(x, y - 1, z);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                boolean open = (m & 4) != 0;
                return open ? (byte)0 : 4;
            }
            if (id == 96) {
                boolean open = (meta & 4) != 0;
                return open ? (byte)0 : 5;
            }
            if (id == 85 || id == 113 || id >= 188 && id <= 192) {
                return 6;
            }
            if (id == 107) {
                boolean open = (meta & 4) != 0;
                return open ? (byte)0 : 7;
            }
            if (id == 44 || id == 126) {
                return 0;
            }
            switch (id) {
                case 53: 
                case 67: 
                case 108: 
                case 109: 
                case 114: 
                case 128: 
                case 134: 
                case 135: 
                case 136: 
                case 156: 
                case 163: 
                case 164: {
                    return 0;
                }
            }
            if (id == 165) {
                return 8;
            }
            if (id == 106) {
                return 9;
            }
            if (id == 65) {
                return 10;
            }
            if (id != 30) break block24;
            return 11;
            {
                catch (Throwable t) {
                    return 0;
                }
            }
        }
        try {
            Material m = b.func_149688_o();
            boolean solid = m != null && m.func_76230_c();
            return solid ? (byte)1 : 0;
        }
        catch (Throwable t) {
            return 0;
        }
    }

    private static class PathFinderEntry {
        RustPathfinding.PathFinderHandle handle;
        boolean woodenDoorAllowed;
        boolean movementBlockAllowed;
        boolean pathingInWater;
        boolean canEntityDrown;

        PathFinderEntry(RustPathfinding.PathFinderHandle handle, boolean w, boolean m, boolean p, boolean d) {
            this.handle = handle;
            this.woodenDoorAllowed = w;
            this.movementBlockAllowed = m;
            this.pathingInWater = p;
            this.canEntityDrown = d;
        }
    }

    public static class WorldAccessAdapter {
        private final IBlockAccess world;

        public WorldAccessAdapter(IBlockAccess world) {
            this.world = world;
        }

        public byte getBlockTypeCode(int x, int y, int z) {
            byte blockType = RustPathfindingBridge.encodeBlock(this.world, x, y, z);
            int metadata = 0;
            try {
                metadata = this.world.func_72805_g(x, y, z);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return blockType;
        }

        public int getBlockMetadata(int x, int y, int z) {
            try {
                return this.world.func_72805_g(x, y, z);
            }
            catch (Throwable t) {
                return 0;
            }
        }

        public boolean canBlockSeeSky(int x, int y, int z) {
            try {
                return !this.world.func_147439_a(x, y, z).func_149688_o().func_76218_k();
            }
            catch (Throwable t) {
                return false;
            }
        }
    }
}

