/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utilsformods.mythandmonsters.recurrentcomplextrewrite;

import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import fr.iamacat.optimizationsandtweaks.utilsformods.mythandmonsters.recurrentcomplextrewrite.ModConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;

public class FileInjector {
    private static ModConfig modConfig;

    public static void setModConfig(ModConfig config) {
        modConfig = config;
    }

    public static void preinit(FMLPreInitializationEvent event) {
        File activeDirectory;
        File minecraftDir = event.getModConfigurationDirectory().getParentFile();
        String structuresDirectoryPath = new File(minecraftDir, "structures").getAbsolutePath();
        String activeDirectoryPath = new File(structuresDirectoryPath, "active").getAbsolutePath();
        File structuresDirectory = new File(structuresDirectoryPath);
        if (!structuresDirectory.exists()) {
            if (structuresDirectory.mkdirs()) {
                System.out.println("Created 'structures' directory");
            } else {
                System.err.println("Failed to create 'structures' directory");
            }
        }
        if (!(activeDirectory = new File(activeDirectoryPath)).exists()) {
            if (activeDirectory.mkdirs()) {
                System.out.println("Created 'active' directory");
            } else {
                System.err.println("Failed to create 'active' directory");
            }
        }
        boolean enableMYTH_AND_MONSTERS_atlantis = modConfig.isMYTH_AND_MONSTERS_atlantisisenabled();
        String destinationDirectoryPath = new File(minecraftDir, "structures/active").getAbsolutePath();
        String[] sourceFiles = new String[]{"MYTH_AND_MONSTERS_atlantisV1.0.rcst"};
        try {
            File destinationDirectory = new File(destinationDirectoryPath);
            File[] filesInDestination = destinationDirectory.listFiles();
            if (filesInDestination != null) {
                for (File file : filesInDestination) {
                    String fileName;
                    if (!file.isFile() || !file.getName().startsWith("MYTH_AND_MONSTERS_") || FileInjector.isValidFileName(fileName = file.getName(), sourceFiles)) continue;
                    if (file.delete()) {
                        System.out.println("File deleted: " + fileName + " (not in the allowed list)");
                        continue;
                    }
                    System.err.println("Failed to delete file: " + fileName);
                }
            }
            for (int i = 0; i < sourceFiles.length; ++i) {
                String sourceFileName = sourceFiles[i];
                boolean isEnabled = false;
                if (i == 0) {
                    isEnabled = enableMYTH_AND_MONSTERS_atlantis;
                }
                if (isEnabled) {
                    InputStream inputStream = FileInjector.class.getClassLoader().getResourceAsStream("assets/optimizationsandtweaks/structres/active/" + sourceFileName);
                    if (inputStream == null) continue;
                    Files.copy(inputStream, new File(destinationDirectoryPath, sourceFileName).toPath(), StandardCopyOption.REPLACE_EXISTING);
                    if (ModConfig.loggingdisabler) continue;
                    System.out.println("Copy successful: " + sourceFileName);
                    continue;
                }
                File existingFile = new File(destinationDirectoryPath, sourceFileName);
                if (existingFile.exists() && existingFile.isFile()) {
                    if (existingFile.delete()) {
                        if (ModConfig.loggingdisabler) continue;
                        System.out.println("File deleted: " + sourceFileName + " (disabled in config)");
                        continue;
                    }
                    if (ModConfig.loggingdisabler) continue;
                    System.err.println("Failed to delete file: " + sourceFileName);
                    continue;
                }
                if (ModConfig.loggingdisabler) continue;
                System.out.println("Skipped copying: " + sourceFileName + " (disabled in config)");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isValidFileName(String fileName, String[] allowedFiles) {
        if (fileName.startsWith("MYTH_AND_MONSTERS_") && !Arrays.asList(allowedFiles).contains(fileName)) {
            return false;
        }
        for (String allowedFile : allowedFiles) {
            if (!fileName.equals(allowedFile)) continue;
            return true;
        }
        return false;
    }
}

