/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.eventshandler;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import fr.iamacat.optimizationsandtweaks.utils.natives.AsyncPathfindingExecutor;

public class AsyncPathfindingTickHandler {
    private int tickCounter = 0;
    private static final int STATS_LOG_INTERVAL = 1200;

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && AsyncPathfindingExecutor.isInitialized()) {
            AsyncPathfindingExecutor.pollResults();
            ++this.tickCounter;
            if (this.tickCounter >= 1200) {
                this.tickCounter = 0;
                this.logStatistics();
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && AsyncPathfindingExecutor.isInitialized()) {
            AsyncPathfindingExecutor.pollResults();
        }
    }

    private void logStatistics() {
        int[] stats;
        if (AsyncPathfindingExecutor.isInitialized() && (stats = AsyncPathfindingExecutor.getStatistics())[0] > 0) {
            FMLLog.info((String)"[AsyncPathfinding] %s", (Object[])new Object[]{AsyncPathfindingExecutor.getStatisticsString()});
            int queueSize = stats[4];
            int workerCount = stats[6];
            int maxQueueSize = workerCount * 4;
            if ((double)queueSize > (double)maxQueueSize * 0.8) {
                FMLLog.warning((String)"[AsyncPathfinding] Queue nearly full: %d/%d (%.1f%%) - Consider increasing worker count", (Object[])new Object[]{queueSize, maxQueueSize, (double)queueSize * 100.0 / (double)maxQueueSize});
            }
            int totalSubmitted = stats[0];
            int totalFailed = stats[2];
            if (totalSubmitted > 100 && (double)totalFailed > (double)totalSubmitted * 0.1) {
                FMLLog.warning((String)"[AsyncPathfinding] High failure rate: %d/%d (%.1f%%)", (Object[])new Object[]{totalFailed, totalSubmitted, (double)totalFailed * 100.0 / (double)totalSubmitted});
            }
        }
    }
}

