/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.core;

import fr.iamacat.optimizationsandtweaks.utils.agrona.collections.Object2ObjectHashMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.management.LowerStringMap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={LowerStringMap.class})
public class MixinLowerStringMap {
    @Unique
    private final Map optimizationsAndTweaks$internalMap = new LinkedHashMap();
    @Unique
    private final Map<String, String> optimizationsAndTweaks$lowercaseCache = new Object2ObjectHashMap<String, String>();

    @Overwrite
    public int size() {
        return this.optimizationsAndTweaks$internalMap.size();
    }

    @Overwrite
    public boolean isEmpty() {
        return this.optimizationsAndTweaks$internalMap.isEmpty();
    }

    @Overwrite
    public boolean containsKey(Object p_containsKey_1_) {
        String lowercaseKey = this.optimizationsAndTweaks$getLowercaseKey(p_containsKey_1_);
        return this.optimizationsAndTweaks$internalMap.containsKey(lowercaseKey);
    }

    @Overwrite
    public boolean containsValue(Object p_containsValue_1_) {
        return this.optimizationsAndTweaks$internalMap.containsValue(p_containsValue_1_);
    }

    @Overwrite
    public Object get(Object p_get_1_) {
        String lowercaseKey = this.optimizationsAndTweaks$getLowercaseKey(p_get_1_);
        return this.optimizationsAndTweaks$internalMap.get(lowercaseKey);
    }

    @Overwrite
    public Object put(String p_put_1_, Object p_put_2_) {
        String lowercaseKey = this.optimizationsAndTweaks$getLowercaseKey(p_put_1_);
        return this.optimizationsAndTweaks$internalMap.put(lowercaseKey, p_put_2_);
    }

    @Overwrite
    public Object remove(Object p_remove_1_) {
        String lowercaseKey = this.optimizationsAndTweaks$getLowercaseKey(p_remove_1_);
        return this.optimizationsAndTweaks$internalMap.remove(lowercaseKey);
    }

    @Overwrite
    public void putAll(Map p_putAll_1_) {
        for (Map.Entry obj : p_putAll_1_.entrySet()) {
            if (!(obj instanceof Map.Entry)) continue;
            Map.Entry entry = obj;
            String lowercaseKey = this.optimizationsAndTweaks$getLowercaseKey(entry.getKey());
            this.optimizationsAndTweaks$internalMap.put(lowercaseKey, entry.getValue());
        }
    }

    @Overwrite
    public void clear() {
        this.optimizationsAndTweaks$internalMap.clear();
    }

    @Overwrite
    public Set keySet() {
        return this.optimizationsAndTweaks$internalMap.keySet();
    }

    @Overwrite
    public Collection values() {
        return this.optimizationsAndTweaks$internalMap.values();
    }

    @Overwrite
    public Set entrySet() {
        return this.optimizationsAndTweaks$internalMap.entrySet();
    }

    @Overwrite
    public Object put(Object p_put_1_, Object p_put_2_) {
        return this.put((String)p_put_1_, p_put_2_);
    }

    @Unique
    private String optimizationsAndTweaks$getLowercaseKey(Object key) {
        if (key instanceof String) {
            String strKey = (String)key;
            return this.optimizationsAndTweaks$lowercaseCache.computeIfAbsent(strKey, this::optimizationsAndTweaks$toLowerCase);
        }
        return this.optimizationsAndTweaks$toLowerCase(key.toString());
    }

    @Unique
    private String optimizationsAndTweaks$toLowerCase(String str) {
        return str.toLowerCase(Locale.ROOT);
    }
}

