/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.core;

import fr.iamacat.optimizationsandtweaks.config.OptimizationsandTweaksConfig;
import fr.iamacat.optimizationsandtweaks.eventshandler.TidyChunkBackportEventHandler;
import fr.iamacat.optimizationsandtweaks.utils.natives.RustPathfinding;
import fr.iamacat.optimizationsandtweaks.utils.optimizationsandtweaks.vanilla.CachedEntitySearch;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={World.class})
public abstract class MixinWorld {
    @Unique
    private static final Map<Integer, CachedEntitySearch> entitySearchCache = new ConcurrentHashMap<Integer, CachedEntitySearch>();
    @Unique
    private static final int CACHE_DURATION_TICKS = 40;
    @Unique
    private static long lastCacheCleanup = 0L;
    @Unique
    private static final int CLEANUP_INTERVAL = 200;

    @Inject(method={"tick"}, at={@At(value="INVOKE")})
    private void onTickInject(CallbackInfo info) {
        long worldTime;
        if (OptimizationsandTweaksConfig.enableTidyChunkBackport) {
            TidyChunkBackportEventHandler.injectInWorldTick((World)this);
        }
        if (OptimizationsandTweaksConfig.enablePathFindingOptimizations && (worldTime = ((World)this).func_82737_E()) % 200L == 0L && RustPathfinding.isAvailable()) {
            RustPathfinding.printProfilerStats();
        }
    }

    @Inject(method={"getEntitiesWithinAABBExcludingEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void cacheEntitySearchForMinions(Entity entity, AxisAlignedBB aabb, CallbackInfoReturnable<List> cir) {
        int cacheKey;
        CachedEntitySearch cached;
        if (!(entity instanceof EntityLivingBase) || entity instanceof EntityPlayer) {
            return;
        }
        World world = (World)this;
        long currentTick = world.func_82737_E();
        if (currentTick - lastCacheCleanup > 200L) {
            lastCacheCleanup = currentTick;
            entitySearchCache.entrySet().removeIf(entry -> currentTick - ((CachedEntitySearch)entry.getValue()).timestamp > 80L);
        }
        if ((cached = entitySearchCache.get(cacheKey = MixinWorld.generateCacheKey(entity, aabb))) != null && currentTick - cached.timestamp < 40L) {
            cir.setReturnValue(new ArrayList<Entity>(cached.entities));
        }
    }

    @Inject(method={"getEntitiesWithinAABBExcludingEntity"}, at={@At(value="RETURN")})
    private void cacheEntitySearchResult(Entity entity, AxisAlignedBB aabb, CallbackInfoReturnable<List> cir) {
        if (!(entity instanceof EntityLivingBase) || entity instanceof EntityPlayer) {
            return;
        }
        World world = (World)this;
        long currentTick = world.func_82737_E();
        int cacheKey = MixinWorld.generateCacheKey(entity, aabb);
        List result = (List)cir.getReturnValue();
        entitySearchCache.put(cacheKey, new CachedEntitySearch(new ArrayList<Entity>(result), currentTick));
    }

    @Unique
    private static int generateCacheKey(Entity entity, AxisAlignedBB aabb) {
        int hash = entity.func_145782_y();
        hash = 31 * hash + (int)aabb.field_72340_a;
        hash = 31 * hash + (int)aabb.field_72338_b;
        hash = 31 * hash + (int)aabb.field_72339_c;
        hash = 31 * hash + (int)(aabb.field_72336_d - aabb.field_72340_a);
        hash = 31 * hash + (int)(aabb.field_72337_e - aabb.field_72338_b);
        hash = 31 * hash + (int)(aabb.field_72334_f - aabb.field_72339_c);
        return hash;
    }
}

