/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.fossilsandarcheologyrevivals;

import fossilsarcheology.Revival;
import fossilsarcheology.server.gen.structure.AcademyGenerator;
import fossilsarcheology.server.gen.structure.FossilStructureGenerator;
import fossilsarcheology.server.structure.util.Structure;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={AcademyGenerator.class})
public class MixinAcademyGenerator {
    @Overwrite(remap=false)
    private final void generateStructure(World world, Random rand, int chunkX, int chunkZ) {
        BiomeGenBase biome = world.func_72959_q().func_76935_a(chunkX, chunkZ);
        FossilStructureGenerator gen = new FossilStructureGenerator();
        int struct = rand.nextInt(FossilStructureGenerator.structures.size());
        int maxAttempts = 10;
        for (int attempts = 0; attempts < maxAttempts; ++attempts) {
            int x = chunkX + rand.nextInt(16);
            int z = chunkZ + rand.nextInt(16);
            int y = world.func_72976_f(x, z);
            if ((y = this.optimizationsAndTweaks$findValidYPosition(world, x, y, z)) < 0) continue;
            Revival.printDebug((String)("Gen: Academy Spawn at " + x + ", " + y + ", " + z));
            Structure selectedStructure = (Structure)FossilStructureGenerator.structures.get(struct);
            int widthX = selectedStructure.getWidthX();
            int widthZ = selectedStructure.getWidthZ();
            int height = selectedStructure.getHeight();
            gen.setStructure(selectedStructure);
            gen.setStructureFacing(rand.nextInt(4));
            gen.func_76484_a(world, rand, x, y, z);
            break;
        }
    }

    @Unique
    private int optimizationsAndTweaks$findValidYPosition(World world, int x, int y, int z) {
        while (y > 0 && !this.optimizationsAndTweaks$isValidSpawnLocation(world, x, y, z)) {
            --y;
        }
        return this.optimizationsAndTweaks$isValidSpawnLocation(world, x, y, z) ? y : -1;
    }

    @Unique
    private boolean optimizationsAndTweaks$isValidSpawnLocation(World world, int x, int y, int z) {
        if (y < 0) {
            return false;
        }
        Block centerBlock = world.func_147439_a(x, y, z);
        Block offset1Block = world.func_147439_a(x + 10, y, z + 11);
        Block offset2Block = world.func_147439_a(x - 10, y, z - 11);
        Block offset3Block = world.func_147439_a(x + 10, y, z - 11);
        Block offset4Block = world.func_147439_a(x - 10, y, z + 11);
        boolean centerSolid = centerBlock.func_149688_o().func_76220_a();
        boolean offset1Solid = offset1Block.func_149688_o().func_76220_a();
        boolean offset2Solid = offset2Block.func_149688_o().func_76220_a();
        boolean offset3Solid = offset3Block.func_149688_o().func_76220_a();
        boolean offset4Solid = offset4Block.func_149688_o().func_76220_a();
        boolean skyAccessible = !world.func_72937_j(x, y, z);
        boolean blockAboveNotWater = world.func_147439_a(x, y + 1, z) != Blocks.field_150355_j;
        return centerSolid && offset1Solid && offset2Solid && offset3Solid && (offset4Solid || skyAccessible) && blockAboveNotWater;
    }
}

