/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.minenautica;

import com.minenautica.Minenautica.Block.WorldGenerator.AluminumOxideWorldGen;
import com.minenautica.Minenautica.CustomRegistry.BlocksAndItems;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenDesert;
import net.minecraft.world.biome.BiomeGenJungle;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={AluminumOxideWorldGen.class})
public class MixinAluminumOxideWorldGen
implements IWorldGenerator {
    private static final int CHUNK_SIZE = 16;
    private static final int MAX_ITERATIONS = 5;
    private static final int[] DIRECTIONS = new int[]{0, 1, 2, 3, 4, 5};

    @Overwrite(remap=false)
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int x = chunkX << 4;
        int z = chunkZ << 4;
        switch (world.field_73011_w.field_76574_g) {
            case 0: {
                this.generateSurface(world, random, x, z);
                break;
            }
            case 10: {
                this.generateMinenautica(world, random, x, z);
            }
        }
    }

    @Overwrite(remap=false)
    private void generateSurface(World world, Random random, int x, int z) {
        Chunk chunk = world.func_72964_e(x >> 4, z >> 4);
        BiomeGenBase biome = chunk.func_76591_a(x & 0xF, z & 0xF, world.func_72959_q());
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        for (int j = 0; j < 5; ++j) {
            boolean isValidPosition = false;
            for (int iteration = 0; iteration < DIRECTIONS.length && !isValidPosition; ++iteration) {
                int Xpos = x + random.nextInt(16);
                int Ypos = random.nextInt(32);
                int Zpos = z + random.nextInt(16);
                if (!(biome instanceof BiomeGenJungle) && !(biome instanceof BiomeGenDesert) || !this.makeVein(world, Xpos, Ypos, Zpos, random.nextInt(2) + 3, Blocks.field_150348_b, BlocksAndItems.aluminumOxideOre, random) || Xpos < chunkX * 16 || Xpos >= (chunkX + 1) * 16 || Zpos < chunkZ * 16 || Zpos >= (chunkZ + 1) * 16) continue;
                isValidPosition = true;
            }
        }
    }

    @Shadow
    private void generateMinenautica(World world, Random random, int x, int z) {
    }

    @Overwrite(remap=false)
    private boolean makeVein(World world, int x, int y, int z, int veinSize, Block blockToReplace, Block blockToPlace, Random random) {
        int direction;
        int[] coords;
        if (world.func_147439_a(x, y, z) != blockToReplace) {
            return false;
        }
        HashSet<String> generatedBlocks = new HashSet<String>();
        world.func_147449_b(x, y, z, blockToPlace);
        generatedBlocks.add(this.optimizationsAndTweaks$getBlockKey(x, y, z));
        for (int blocksNeeded = veinSize - 1; blocksNeeded > 0 && this.optimizationsAndTweaks$isValidPosition(world, (coords = this.optimizationsAndTweaks$generateCoordinates(x, y, z, direction = random.nextInt(6)))[0], coords[1], coords[2], generatedBlocks, blockToReplace); --blocksNeeded) {
            world.func_147449_b(coords[0], coords[1], coords[2], blockToPlace);
            generatedBlocks.add(this.optimizationsAndTweaks$getBlockKey(coords[0], coords[1], coords[2]));
        }
        return true;
    }

    @Unique
    private int[] optimizationsAndTweaks$generateCoordinates(int x, int y, int z, int direction) {
        int[] coords = new int[]{x, y, z};
        switch (direction) {
            case 0: {
                coords[0] = coords[0] + 1;
                break;
            }
            case 1: {
                coords[0] = coords[0] - 1;
                break;
            }
            case 2: {
                coords[1] = coords[1] + 1;
                break;
            }
            case 3: {
                coords[1] = coords[1] - 1;
                break;
            }
            case 4: {
                coords[2] = coords[2] + 1;
                break;
            }
            case 5: {
                coords[2] = coords[2] - 1;
                break;
            }
        }
        return coords;
    }

    @Unique
    private boolean optimizationsAndTweaks$isValidPosition(World world, int x, int y, int z, Set<String> generatedBlocks, Block blockToReplace) {
        String blockKey = this.optimizationsAndTweaks$getBlockKey(x, y, z);
        return !generatedBlocks.contains(blockKey) && world.func_147439_a(x, y, z) == blockToReplace;
    }

    @Unique
    private String optimizationsAndTweaks$getBlockKey(int x, int y, int z) {
        return x + "," + y + "," + z;
    }
}

