/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.natives;

import cpw.mods.fml.common.FMLLog;
import fr.iamacat.optimizationsandtweaks.utils.natives.RustPathfinding;
import fr.iamacat.optimizationsandtweaks.utils.natives.RustPathfindingBridge;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class AsyncPathfindingExecutor {
    private static boolean initialized = false;
    private static final AtomicLong nextRequestId = new AtomicLong(1L);
    private static ExecutorService executor;
    private static final ConcurrentHashMap<Long, RequestContext> pendingRequests;

    public static synchronized void initialize(int workerCount, int queueSize) {
        if (initialized) {
            FMLLog.warning((String)"[AsyncPathfinding] Already initialized", (Object[])new Object[0]);
            return;
        }
        if (!RustPathfinding.isAvailable()) {
            FMLLog.warning((String)"[AsyncPathfinding] Rust pathfinding not available", (Object[])new Object[0]);
            return;
        }
        try {
            executor = Executors.newFixedThreadPool(Math.max(1, workerCount));
            initialized = true;
            FMLLog.info((String)"[AsyncPathfinding] Initialized with %d workers (direct world accessor)", (Object[])new Object[]{workerCount});
        }
        catch (Throwable e) {
            FMLLog.warning((String)"[AsyncPathfinding] Failed to initialize executor: %s", (Object[])new Object[]{e.getMessage()});
            initialized = false;
            return;
        }
    }

    public static synchronized void initializeAuto() {
        int cores = Runtime.getRuntime().availableProcessors();
        int workers = Math.max(2, cores / 2);
        int queueSize = workers * 4;
        AsyncPathfindingExecutor.initialize(workers, queueSize);
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public boolean canBreakDoors(EntityLiving entity) {
        if (entity.field_70714_bg.field_75782_a != null) {
            for (Object entryObj : entity.field_70714_bg.field_75782_a) {
                EntityAITasks.EntityAITaskEntry entry = (EntityAITasks.EntityAITaskEntry)entryObj;
                if (!(entry.field_75733_a instanceof EntityAIBreakDoor)) continue;
                return true;
            }
        }
        return false;
    }

    public static long submitPathfinding(IBlockAccess world, Entity entity, double targetX, double targetY, double targetZ, float maxDistance, int priority, boolean isWoodenDoorAllowed, boolean isMovementBlockAllowed, boolean isPathingInWater, boolean canEntityDrown) {
        if (!initialized) {
            FMLLog.warning((String)"[AsyncPathfinding] Not initialized", (Object[])new Object[0]);
            return 0L;
        }
        long requestId = nextRequestId.getAndIncrement();
        pendingRequests.put(requestId, new RequestContext(entity));
        executor.submit(() -> {
            try {
                PathEntity path = RustPathfindingBridge.findPathDirect(world, entity, targetX, targetY, targetZ, maxDistance, isWoodenDoorAllowed, isMovementBlockAllowed, isPathingInWater, canEntityDrown);
                RequestContext context = pendingRequests.remove(requestId);
                if (context != null) {
                    if (path != null && context.onComplete != null) {
                        context.onComplete.accept(path);
                    } else if (path == null && context.onFailure != null) {
                        context.onFailure.accept("No path found");
                    }
                }
            }
            catch (Throwable e) {
                RequestContext context = pendingRequests.remove(requestId);
                if (context != null && context.onFailure != null) {
                    context.onFailure.accept("Error: " + e.getMessage());
                }
                FMLLog.warning((String)"[AsyncPathfinding] Error in direct pathfinding task: %s", (Object[])new Object[]{e.getMessage()});
            }
        });
        return requestId;
    }

    public static long submitPathfinding(IBlockAccess world, Entity entity, double targetX, double targetY, double targetZ, float maxDistance, boolean isWoodenDoorAllowed, boolean isMovementBlockAllowed, boolean isPathingInWater, boolean canEntityDrown) {
        int priority = AsyncPathfindingExecutor.determinePriority(entity, world);
        return AsyncPathfindingExecutor.submitPathfinding(world, entity, targetX, targetY, targetZ, maxDistance, priority, isWoodenDoorAllowed, isMovementBlockAllowed, isPathingInWater, canEntityDrown);
    }

    public static long submitPathfindingWithCallback(IBlockAccess world, Entity entity, double targetX, double targetY, double targetZ, float maxDistance, Consumer<PathEntity> onComplete, Consumer<String> onFailure, boolean isWoodenDoorAllowed, boolean isMovementBlockAllowed, boolean isPathingInWater, boolean canEntityDrown) {
        RequestContext context;
        long requestId = AsyncPathfindingExecutor.submitPathfinding(world, entity, targetX, targetY, targetZ, maxDistance, AsyncPathfindingExecutor.determinePriority(entity, world), isWoodenDoorAllowed, isMovementBlockAllowed, isPathingInWater, canEntityDrown);
        if (requestId != 0L && (context = pendingRequests.get(requestId)) != null) {
            context.onComplete = onComplete;
            context.onFailure = onFailure;
        }
        return requestId;
    }

    public static int pollResults() {
        long pathHandle;
        if (!initialized) {
            return 0;
        }
        int processed = 0;
        int[] outRequestId = new int[1];
        while ((pathHandle = RustPathfinding.tryRecvAsyncResult(outRequestId)) != 0L) {
            long requestId = outRequestId[0];
            RequestContext context = pendingRequests.remove(requestId);
            if (context != null) {
                try {
                    PathEntity path = AsyncPathfindingExecutor.convertRustPath(pathHandle);
                    if (path != null && context.onComplete != null) {
                        context.onComplete.accept(path);
                    } else if (path == null && context.onFailure != null) {
                        context.onFailure.accept("No path found");
                    }
                }
                catch (Exception e) {
                    if (context.onFailure != null) {
                        context.onFailure.accept("Error: " + e.getMessage());
                    }
                    FMLLog.warning((String)"[AsyncPathfinding] Error processing result: %s", (Object[])new Object[]{e.getMessage()});
                }
            }
            ++processed;
        }
        return processed;
    }

    public static int[] getStatistics() {
        if (!initialized) {
            return new int[7];
        }
        return RustPathfinding.getAsyncExecutorStats();
    }

    public static String getStatisticsString() {
        int[] stats = AsyncPathfindingExecutor.getStatistics();
        return String.format("Async Pathfinding Stats - Submitted: %d, Completed: %d, Failed: %d, Queue: %d/%d, Active: %d/%d", stats[0], stats[1], stats[2], stats[4], stats[6] * 4, stats[5], stats[6]);
    }

    public static void cancelRequest(long requestId) {
        pendingRequests.remove(requestId);
    }

    public static int getPendingCount() {
        return pendingRequests.size();
    }

    public static synchronized void shutdown() {
        if (!initialized) {
            return;
        }
        FMLLog.info((String)"[AsyncPathfinding] Shutting down - %d pending requests", (Object[])new Object[]{pendingRequests.size()});
        FMLLog.info((String)AsyncPathfindingExecutor.getStatisticsString(), (Object[])new Object[0]);
        try {
            if (executor != null) {
                executor.shutdownNow();
                executor = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        pendingRequests.clear();
        initialized = false;
    }

    private static int determinePriority(Entity entity, IBlockAccess world) {
        EntityPlayer nearestPlayer;
        World worldObj;
        try {
            EntityLiving el;
            if (entity instanceof EntityLiving && (el = (EntityLiving)entity).func_70638_az() != null && el.func_70638_az().func_70089_S()) {
                return 80;
            }
        }
        catch (Throwable el) {
            // empty catch block
        }
        if (entity instanceof EntityPlayer) {
            return 100;
        }
        if (entity instanceof EntityLiving && ((EntityLiving)entity).func_94056_bM() || entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_110138_aP() > 100.0f) {
            return 100;
        }
        if (entity instanceof EntityMob) {
            EntityPlayer nearestPlayer2;
            if (world instanceof World && (nearestPlayer2 = (worldObj = (World)world).func_72890_a(entity, -1.0)) != null) {
                double distance = entity.func_70032_d((Entity)nearestPlayer2);
                if (distance < 32.0) {
                    return 75;
                }
                if (distance < 64.0) {
                    return 50;
                }
            }
            return 50;
        }
        if (world instanceof World && (nearestPlayer = (worldObj = (World)world).func_72890_a(entity, -1.0)) != null) {
            double distance = entity.func_70032_d((Entity)nearestPlayer);
            if (distance < 64.0) {
                return 50;
            }
            if (distance < 128.0) {
                return 25;
            }
        }
        return 10;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PathEntity convertRustPath(long pathHandle) {
        if (pathHandle == 0L) {
            return null;
        }
        try (RustPathfinding.PathEntityHandle rustPath = new RustPathfinding.PathEntityHandle(pathHandle);){
            int[] allPoints = rustPath.getAllPoints();
            if (allPoints.length == 0) {
                PathEntity pathEntity = null;
                return pathEntity;
            }
            int pointCount = allPoints.length / 3;
            PathPoint[] points = new PathPoint[pointCount];
            for (int i = 0; i < pointCount; ++i) {
                int x = allPoints[i * 3];
                int y = allPoints[i * 3 + 1];
                int z = allPoints[i * 3 + 2];
                points[i] = new PathPoint(x, y, z);
            }
            if (pointCount == 1) {
                PathPoint p = points[0];
                PathPoint[] doubled = new PathPoint[]{p, new PathPoint(p.field_75839_a, p.field_75837_b, p.field_75838_c)};
                PathEntity pathEntity = new PathEntity(doubled);
                return pathEntity;
            }
            PathEntity pathEntity = new PathEntity(points);
            return pathEntity;
        }
        catch (Exception e) {
            FMLLog.warning((String)"[AsyncPathfinding] Error converting path: %s", (Object[])new Object[]{e.getMessage()});
            return null;
        }
    }

    static {
        pendingRequests = new ConcurrentHashMap();
    }

    private static class RequestContext {
        final Entity entity;
        Consumer<PathEntity> onComplete;
        Consumer<String> onFailure;
        final long submittedAt;

        RequestContext(Entity entity) {
            this.entity = entity;
            this.submittedAt = System.currentTimeMillis();
        }
    }
}

