/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.natives;

import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class NativeLibraryLoader {
    private static final String NATIVES_DIR = "natives";
    private static final Set<String> loadedLibraries = Collections.synchronizedSet(new HashSet());

    public static boolean loadLibrary(String libraryName, File minecraftDir) {
        try {
            File targetFile;
            String osDir = NativeLibraryLoader.getOSDirectory();
            String platformLibName = NativeLibraryLoader.getPlatformLibraryName(libraryName);
            if (loadedLibraries.contains(platformLibName)) {
                return true;
            }
            String resourcePath = "/assets/optimizationsandtweaks/natives/" + osDir + "/" + platformLibName;
            File nativesDir = new File(minecraftDir, NATIVES_DIR);
            if (!nativesDir.exists()) {
                nativesDir.mkdirs();
            }
            if (NativeLibraryLoader.shouldExtractLibrary(resourcePath, targetFile = new File(nativesDir, platformLibName))) {
                NativeLibraryLoader.extractLibrary(resourcePath, targetFile);
                FMLLog.info((String)"[OptimizationsAndTweaks] Extracted native library: %s", (Object[])new Object[]{platformLibName});
            } else {
                FMLLog.info((String)"[OptimizationsAndTweaks] Native library already up to date: %s", (Object[])new Object[]{platformLibName});
            }
            System.load(targetFile.getAbsolutePath());
            loadedLibraries.add(platformLibName);
            FMLLog.info((String)"[OptimizationsAndTweaks] Successfully loaded native library: %s", (Object[])new Object[]{platformLibName});
            return true;
        }
        catch (Exception e) {
            FMLLog.severe((String)"[OptimizationsAndTweaks] Failed to load native library: %s", (Object[])new Object[]{e.getMessage()});
            e.printStackTrace();
            return false;
        }
    }

    private static String getOSDirectory() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return "windows";
        }
        if (os.contains("mac")) {
            return "macos";
        }
        return "linux";
    }

    private static String getPlatformLibraryName(String baseName) {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            return baseName + ".dll";
        }
        if (os.contains("mac")) {
            return "lib" + baseName + ".dylib";
        }
        return "lib" + baseName + ".so";
    }

    private static boolean shouldExtractLibrary(String resourcePath, File targetFile) {
        if (!targetFile.exists()) {
            return true;
        }
        try {
            String resourceChecksum = NativeLibraryLoader.getResourceChecksum(resourcePath);
            String fileChecksum = NativeLibraryLoader.getFileChecksum(targetFile);
            return !resourceChecksum.equals(fileChecksum);
        }
        catch (Exception e) {
            FMLLog.warning((String)"[OptimizationsAndTweaks] Could not compare checksums, will re-extract library", (Object[])new Object[0]);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractLibrary(String resourcePath, File targetFile) throws IOException {
        InputStream in = NativeLibraryLoader.class.getResourceAsStream(resourcePath);
        if (in == null) {
            throw new IOException("Native library not found in resources: " + resourcePath);
        }
        try {
            targetFile.getParentFile().mkdirs();
            try (FileOutputStream out = new FileOutputStream(targetFile);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
        }
        finally {
            in.close();
        }
        targetFile.setExecutable(true);
        targetFile.setReadable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResourceChecksum(String resourcePath) throws IOException, NoSuchAlgorithmException {
        InputStream in = NativeLibraryLoader.class.getResourceAsStream(resourcePath);
        if (in == null) {
            throw new IOException("Resource not found: " + resourcePath);
        }
        try {
            int bytesRead;
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            while ((bytesRead = in.read(buffer)) != -1) {
                md.update(buffer, 0, bytesRead);
            }
            String string = NativeLibraryLoader.bytesToHex(md.digest());
            return string;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileChecksum(File file) throws IOException, NoSuchAlgorithmException {
        try (FileInputStream in = new FileInputStream(file);){
            int bytesRead;
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            while ((bytesRead = in.read(buffer)) != -1) {
                md.update(buffer, 0, bytesRead);
            }
            String string = NativeLibraryLoader.bytesToHex(md.digest());
            return string;
        }
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static boolean isLibraryLoaded() {
        return !loadedLibraries.isEmpty();
    }
}

