/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.natives;

import cpw.mods.fml.common.FMLLog;
import fr.iamacat.optimizationsandtweaks.utils.natives.NativeLibraryLoader;
import java.io.File;

public class RustFFI {
    private static boolean initialized = false;
    private static boolean libraryAvailable = false;

    private static native void rust_hello_world();

    private static native String rust_get_hello_string();

    private static native void rust_print_message(String var0);

    public static boolean initialize(File minecraftDir) {
        if (initialized) {
            return libraryAvailable;
        }
        initialized = true;
        try {
            boolean ok = true;
            ok &= NativeLibraryLoader.loadLibrary("optimizationsandtweaks_pathfinding", minecraftDir);
            if (ok &= NativeLibraryLoader.loadLibrary("optimizationsandtweaks_blocksupdates", minecraftDir)) {
                libraryAvailable = true;
                FMLLog.info((String)"[OptimizationsAndTweaks] Rust FFI initialized successfully using JNI", (Object[])new Object[0]);
                return true;
            }
            FMLLog.info((String)"[OptimizationsAndTweaks] Rust native library not available, FFI features will be disabled", (Object[])new Object[0]);
            return false;
        }
        catch (UnsatisfiedLinkError e) {
            FMLLog.info((String)"[OptimizationsAndTweaks] Rust native library not found: %s", (Object[])new Object[]{e.getMessage()});
            FMLLog.info((String)"[OptimizationsAndTweaks] Rust FFI features will be disabled. This is optional and does not affect core functionality.", (Object[])new Object[0]);
            return false;
        }
        catch (Exception e) {
            FMLLog.info((String)"[OptimizationsAndTweaks] Could not initialize Rust FFI: %s", (Object[])new Object[]{e.getMessage()});
            FMLLog.info((String)"[OptimizationsAndTweaks] Rust FFI features will be disabled. This is optional and does not affect core functionality.", (Object[])new Object[0]);
            return false;
        }
    }

    public static void printHelloWorld() {
        if (!libraryAvailable) {
            return;
        }
        try {
            RustFFI.rust_hello_world();
        }
        catch (UnsatisfiedLinkError e) {
            FMLLog.warning((String)"[OptimizationsAndTweaks] Native method rust_hello_world not available", (Object[])new Object[0]);
            libraryAvailable = false;
        }
        catch (Exception e) {
            FMLLog.warning((String)"[OptimizationsAndTweaks] Error calling rust_hello_world: %s", (Object[])new Object[]{e.getMessage()});
        }
    }

    public static String getHelloString() {
        if (!libraryAvailable) {
            return null;
        }
        try {
            return RustFFI.rust_get_hello_string();
        }
        catch (UnsatisfiedLinkError e) {
            FMLLog.warning((String)"[OptimizationsAndTweaks] Native method rust_get_hello_string not available", (Object[])new Object[0]);
            libraryAvailable = false;
            return null;
        }
        catch (Exception e) {
            FMLLog.warning((String)"[OptimizationsAndTweaks] Error calling rust_get_hello_string: %s", (Object[])new Object[]{e.getMessage()});
            return null;
        }
    }

    public static void printMessage(String message) {
        if (!libraryAvailable) {
            return;
        }
        try {
            RustFFI.rust_print_message(message);
        }
        catch (UnsatisfiedLinkError e) {
            FMLLog.warning((String)"[OptimizationsAndTweaks] Native method rust_print_message not available", (Object[])new Object[0]);
            libraryAvailable = false;
        }
        catch (Exception e) {
            FMLLog.warning((String)"[OptimizationsAndTweaks] Error calling rust_print_message: %s", (Object[])new Object[]{e.getMessage()});
        }
    }

    public static boolean isInitialized() {
        return initialized && libraryAvailable;
    }
}

