/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.client.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.ProgressManager;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.ITickable;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={TextureManager.class})
public class MixinTextureManager
implements ITickable,
IResourceManagerReloadListener {
    @Shadow
    private static final Logger field_147646_a = LogManager.getLogger();
    @Shadow
    private final Map field_110585_a = Maps.newHashMap();
    @Shadow
    private final Map field_130089_b = Maps.newHashMap();
    @Shadow
    private final List field_110583_b = Lists.newArrayList();
    @Shadow
    private final Map field_110584_c = Maps.newHashMap();
    @Shadow
    private IResourceManager field_110582_d;
    @Unique
    private final List<ITickable> orderedTickables = Lists.newArrayList();

    public MixinTextureManager(IResourceManager p_i1284_1_) {
        this.field_110582_d = p_i1284_1_;
    }

    @Shadow
    public ResourceLocation func_130087_a(int p_130087_1_) {
        return (ResourceLocation)this.field_130089_b.get(p_130087_1_);
    }

    @Shadow
    public boolean func_130088_a(ResourceLocation p_130088_1_, TextureMap p_130088_2_) {
        if (this.func_110580_a(p_130088_1_, (ITickableTextureObject)p_130088_2_)) {
            this.field_130089_b.put(p_130088_2_.func_130086_a(), p_130088_1_);
            return true;
        }
        return false;
    }

    @Overwrite
    public boolean func_110580_a(ResourceLocation p_110580_1_, ITickableTextureObject p_110580_2_) {
        if (this.func_110579_a(p_110580_1_, (ITextureObject)p_110580_2_)) {
            this.orderedTickables.add((ITickable)p_110580_2_);
            return true;
        }
        return false;
    }

    @Overwrite
    public boolean func_110579_a(ResourceLocation p_110579_1_, ITextureObject p_110579_2_) {
        boolean flag = true;
        ITextureObject p_110579_2_2 = p_110579_2_;
        try {
            p_110579_2_.func_110551_a(this.field_110582_d);
        }
        catch (IOException ioexception) {
            field_147646_a.warn("Failed to load texture: " + p_110579_1_, (Throwable)ioexception);
            p_110579_2_2 = TextureUtil.field_111001_a;
            this.field_110585_a.put(p_110579_1_, p_110579_2_2);
            flag = false;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Registering texture");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Resource location being registered");
            crashreportcategory.func_71507_a("Resource location", (Object)p_110579_1_);
            crashreportcategory.func_71500_a("Texture object class", () -> p_110579_2_.getClass().getName());
            throw new ReportedException(crashreport);
        }
        this.field_110585_a.put(p_110579_1_, p_110579_2_2);
        return flag;
    }

    @Shadow
    public ITextureObject func_110581_b(ResourceLocation p_110581_1_) {
        return (ITextureObject)this.field_110585_a.get(p_110581_1_);
    }

    @Overwrite
    public ResourceLocation func_110578_a(String p_110578_1_, DynamicTexture p_110578_2_) {
        Integer integer = (Integer)this.field_110584_c.get(p_110578_1_);
        integer = integer == null ? Integer.valueOf(1) : Integer.valueOf(integer + 1);
        this.field_110584_c.put(p_110578_1_, integer);
        ResourceLocation resourcelocation = new ResourceLocation(String.format("dynamic/%s_%d", p_110578_1_, integer));
        this.func_110579_a(resourcelocation, (ITextureObject)p_110578_2_);
        return resourcelocation;
    }

    @Overwrite
    public void func_110550_d() {
        for (ITickable tickable : this.orderedTickables) {
            tickable.func_110550_d();
        }
    }

    @Shadow
    public void func_147645_c(ResourceLocation p_147645_1_) {
        ITextureObject itextureobject = this.func_110581_b(p_147645_1_);
        if (itextureobject != null) {
            TextureUtil.func_147942_a((int)itextureobject.func_110552_b());
        }
    }

    @Shadow
    public void func_110549_a(IResourceManager p_110549_1_) {
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"Reloading Texture Manager", (int)this.field_110585_a.keySet().size(), (boolean)true);
        Iterator iterator = this.field_110585_a.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry2 = o = iterator.next();
            bar.step(entry2.getKey().toString());
            this.func_110579_a((ResourceLocation)entry2.getKey(), (ITextureObject)entry2.getValue());
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }
}

