/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.akatsuki;

import com.akazuki.animation.common.MCACommonLibrary.IMCAnimatedEntity;
import com.akazuki.animation.common.MCACommonLibrary.animation.AnimTickHandler;
import com.akazuki.animation.common.MCACommonLibrary.animation.AnimationHandler;
import com.akazuki.animation.common.MCACommonLibrary.animation.Channel;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fr.iamacat.optimizationsandtweaks.config.OptimizationsandTweaksConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AnimationHandler.class})
public class MixinAnimationHandler {
    @Shadow
    public static AnimTickHandler animTickHandler;
    @Shadow
    private IMCAnimatedEntity animatedEntity;
    @Shadow
    public ArrayList<Channel> animCurrentChannels = new ArrayList();
    @Shadow
    public HashMap<String, Long> animPrevTime = new HashMap();
    @Shadow
    public HashMap<String, Float> animCurrentFrame = new HashMap();
    @Shadow
    private HashMap<String, ArrayList<String>> animationEvents = new HashMap();

    @Inject(method={"animationsUpdate"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    public void animationsUpdate(CallbackInfo ci) {
        if (OptimizationsandTweaksConfig.enableMixinAnimationHandler) {
            Iterator<Channel> channelIterator = this.animCurrentChannels.iterator();
            while (channelIterator.hasNext()) {
                Channel anim = channelIterator.next();
                float prevFrame = this.animCurrentFrame.get(anim.name).floatValue();
                boolean animStatus = this.updateAnimation(anim);
                if (prevFrame != -1.0f) {
                    this.fireAnimationEvent(anim, prevFrame, this.animCurrentFrame.get(anim.name).floatValue());
                }
                if (animStatus) continue;
                channelIterator.remove();
                this.animPrevTime.remove(anim.name);
                this.animCurrentFrame.remove(anim.name);
                this.animationEvents.get(anim.name).clear();
            }
            ci.cancel();
        }
    }

    @Unique
    private boolean updateAnimation(Channel channel) {
        if (!(FMLCommonHandler.instance().getEffectiveSide().isServer() || FMLCommonHandler.instance().getEffectiveSide().isClient() && !MixinAnimationHandler.isGamePaused())) {
            long prevTime = System.nanoTime();
            this.animPrevTime.put(channel.name, prevTime);
            return true;
        }
        if (channel.mode != 3) {
            long currentTime;
            double deltaTime;
            float numberOfSkippedFrames;
            long prevTime = this.animPrevTime.get(channel.name);
            float prevFrame = this.animCurrentFrame.get(channel.name).floatValue();
            float currentFrame = prevFrame + (numberOfSkippedFrames = (float)((deltaTime = (double)((currentTime = System.nanoTime()) - prevTime) / 1.0E9) * (double)channel.fps));
            if (currentFrame < (float)(channel.totalFrames - 1)) {
                this.animPrevTime.put(channel.name, currentTime);
                this.animCurrentFrame.put(channel.name, Float.valueOf(currentFrame));
                return true;
            }
            if (channel.mode == 1) {
                this.animPrevTime.put(channel.name, currentTime);
                this.animCurrentFrame.put(channel.name, Float.valueOf(0.0f));
                return true;
            }
            return false;
        }
        return true;
    }

    @Unique
    private void fireAnimationEvent(Channel anim, float prevFrame, float frame) {
        if (MixinAnimationHandler.isWorldRemote(this.animatedEntity)) {
            this.fireAnimationEventClientSide(anim, prevFrame, frame);
        } else {
            this.fireAnimationEventServerSide(anim, prevFrame, frame);
        }
    }

    @Unique
    private static boolean isWorldRemote(IMCAnimatedEntity animatedEntity) {
        return ((Entity)animatedEntity).field_70170_p.field_72995_K;
    }

    @Unique
    public void fireAnimationEventServerSide(Channel channel, float prevFrame, float frame) {
    }

    @Unique
    @SideOnly(value=Side.CLIENT)
    public void fireAnimationEventClientSide(Channel channel, float prevFrame, float frame) {
    }

    @Unique
    @SideOnly(value=Side.CLIENT)
    private static boolean isGamePaused() {
        Minecraft MC = Minecraft.func_71410_x();
        return MC.func_71356_B() && MC.field_71462_r != null && MC.field_71462_r.func_73868_f() && !MC.func_71401_C().func_71344_c();
    }
}

