/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.opis;

import com.google.common.collect.HashBasedTable;
import cpw.mods.fml.common.ModContainer;
import mcp.mobius.opis.data.profilers.Clock;
import mcp.mobius.opis.data.profilers.ProfilerAbstract;
import mcp.mobius.opis.data.profilers.ProfilerEvent;
import mcp.mobius.shadow.org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ProfilerEvent.class})
public abstract class MixinopisProfilerEvent
extends ProfilerAbstract {
    @Shadow
    private Clock.IClock clock = Clock.getNewClock();
    @Shadow
    public HashBasedTable<Class, String, DescriptiveStatistics> data = HashBasedTable.create();
    @Shadow
    public HashBasedTable<Class, String, String> dataMod = HashBasedTable.create();
    @Shadow
    public HashBasedTable<Class, String, DescriptiveStatistics> dataTick = HashBasedTable.create();
    @Shadow
    public HashBasedTable<Class, String, String> dataModTick = HashBasedTable.create();

    @Overwrite(remap=false)
    public void stop(Object event, Object pkg, Object handler, Object mod) {
        this.clock.stop();
        String eventName = event.getClass().getSimpleName();
        if (eventName.contains("TickEvent")) {
            try {
                String name = pkg + "|" + handler.getClass().getSimpleName();
                if (this.dataTick.get(event.getClass(), (Object)name) == null) {
                    this.dataTick.put(event.getClass(), (Object)name, (Object)new DescriptiveStatistics(250));
                    this.dataModTick.put(event.getClass(), (Object)name, (Object)((ModContainer)mod).getName());
                }
                ((DescriptiveStatistics)this.dataTick.get(event.getClass(), (Object)name)).addValue((double)this.clock.getDelta());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                String name = pkg + "|" + handler.getClass().getSimpleName();
                if (this.data.get(event.getClass(), (Object)name) == null) {
                    this.data.put(event.getClass(), (Object)name, (Object)new DescriptiveStatistics(250));
                    this.dataMod.put(event.getClass(), (Object)name, (Object)((ModContainer)mod).getName());
                }
                ((DescriptiveStatistics)this.data.get(event.getClass(), (Object)name)).addValue((double)this.clock.getDelta());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

