/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.shipwreck;

import com.winslow.shipwreckworldgen.RandomWeightedShip;
import com.winslow.shipwreckworldgen.ShipwreckConfig;
import com.winslow.shipwreckworldgen.ShipwreckGen;
import com.winslow.shipwreckworldgen.shipwrecks.RowboatGen;
import com.winslow.shipwreckworldgen.shipwrecks.SailboatSideGen;
import com.winslow.shipwreckworldgen.shipwrecks.SailboatUprightGen;
import com.winslow.shipwreckworldgen.shipwrecks.SchoonerGen;
import com.winslow.shipwreckworldgen.shipwrecks.SloopGen;
import com.winslow.shipwreckworldgen.shipwrecks.SpireGen;
import com.winslow.shipwreckworldgen.shipwrecks.WaverunnerGen;
import cpw.mods.fml.common.IWorldGenerator;
import fr.iamacat.optimizationsandtweaks.config.OptimizationsandTweaksConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ShipwreckGen.class})
public class MixinFixCascadingFromShipwreckGen
implements IWorldGenerator {
    @Unique
    private static List<BiomeGenBase> validBiomes = Arrays.asList(BiomeGenBase.field_76787_r, BiomeGenBase.field_150577_O, BiomeGenBase.field_150576_N);

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76574_g == 0 && OptimizationsandTweaksConfig.enableMixinFixCascadingFromShipwreckGen) {
            this.generateSurface(world, chunkX * 16, chunkZ * 16, random);
        }
    }

    @Unique
    private void generateSurface(World world, int posX, int posZ, Random random) {
        BiomeGenBase biome = world.func_72807_a(posX, posZ);
        if (this.isValidBiome(biome) && this.canSpawnStructureAtCoords(posX, posZ, random)) {
            String structure = this.getRandomStructure(random);
            this.generateStructure(world, posX, posZ, random, structure);
        }
    }

    @Unique
    private boolean isValidBiome(BiomeGenBase biome) {
        return validBiomes.contains(biome);
    }

    @Unique
    private boolean canSpawnStructureAtCoords(int posX, int posZ, Random random) {
        int maxDist = ShipwreckConfig.shipwreckMaxDistance;
        int minDist = ShipwreckConfig.shipwreckMinDistance;
        if (minDist < 0) {
            minDist = 0;
        }
        int xVal = posX / 16;
        int zVal = posZ / 16;
        if (xVal < 0) {
            xVal *= -1;
        }
        if (zVal < 0) {
            zVal *= -1;
        }
        int chunkRange = maxDist - minDist;
        int checkX = xVal / maxDist;
        int checkZ = zVal / maxDist;
        checkX *= maxDist;
        checkZ *= maxDist;
        return xVal == (checkX += random.nextInt(chunkRange)) && zVal == (checkZ += random.nextInt(chunkRange));
    }

    @Unique
    private String getRandomStructure(Random random) {
        RandomWeightedShip weightedShip = new RandomWeightedShip();
        weightedShip.add((double)ShipwreckConfig.waverunnerOceanRarity, (Object)"waverunner");
        weightedShip.add((double)ShipwreckConfig.schoonerOceanRarity, (Object)"schooner");
        weightedShip.add((double)ShipwreckConfig.sloopOceanRarity, (Object)"sloop");
        weightedShip.add((double)ShipwreckConfig.sailboatOceanRarity, (Object)"sailboat");
        weightedShip.add((double)ShipwreckConfig.rowboatOceanRarity, (Object)"rowboat");
        if (this.isValidBiome(BiomeGenBase.field_150576_N)) {
            weightedShip.add((double)ShipwreckConfig.spireRarity, (Object)"spire");
        }
        return (String)weightedShip.next();
    }

    @Unique
    private void generateStructure(World world, int posX, int posZ, Random random, String structure) {
        switch (structure) {
            case "rowboat": {
                RowboatGen.generateRowboat((World)world, (Random)random, (int)posX, (int)posZ);
                break;
            }
            case "sailUp": {
                SailboatUprightGen.generateSailboatUpright((World)world, (Random)random, (int)posX, (int)posZ);
                break;
            }
            case "sailSide": {
                SailboatSideGen.generateSailboatSide((World)world, (Random)random, (int)posX, (int)posZ);
                break;
            }
            case "sloop": {
                SloopGen.generateSloop((World)world, (Random)random, (int)posX, (int)posZ);
                break;
            }
            case "schooner": {
                SchoonerGen.generateSchooner((World)world, (Random)random, (int)posX, (int)posZ);
                break;
            }
            case "waverunner": {
                WaverunnerGen.generateWaverunner((World)world, (Random)random, (int)posX, (int)posZ);
                break;
            }
            case "spire": {
                SpireGen.generateSpire((World)world, (Random)random, (int)posX, (int)posZ);
                break;
            }
        }
    }
}

