/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.spiriteores;

import fr.iamacat.optimizationsandtweaks.utilsformods.spiritores.SpiritOreConfig;
import howl01.spiritores.SpiritOres;
import howl01.spiritores.SpiritOresGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SpiritOresGenerator.class})
public class MixinSpiritOresGenerator {
    @Inject(method={"generate"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void onGenerate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider, CallbackInfo ci) {
        int xBase = chunkX * 16;
        int zBase = chunkZ * 16;
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                if (SpiritOreConfig.CHARRED_LEAD.isEnabled()) {
                    this.generateOre(world, random, xBase, zBase, SpiritOres.charredLeadOre, 7, 7, 10, 108, "netherrack");
                }
                if (SpiritOreConfig.AMETHYST.isEnabled()) {
                    this.generateOre(world, random, xBase, zBase, SpiritOres.amethystOre, 7, 10, 10, 108, "netherrack");
                }
                if (SpiritOreConfig.MAGNETITE.isEnabled()) {
                    this.generateOre(world, random, xBase, zBase, SpiritOres.magnetiteOre, 7, 20, 10, 108, "netherrack");
                }
                if (!SpiritOreConfig.MAGMA_SPIRIT.isEnabled()) break;
                this.generateOre(world, random, xBase, zBase, SpiritOres.magmaSpiritOre, 5, 5, 10, 108, "netherrack");
                break;
            }
            case 0: {
                if (SpiritOreConfig.ALUMINUM.isEnabled()) {
                    this.generateOre(world, random, xBase, zBase, SpiritOres.aluminumOre, 6, 20, 0, 64, null);
                }
                if (SpiritOreConfig.COPPER.isEnabled()) {
                    this.generateOre(world, random, xBase, zBase, SpiritOres.copperOre, 6, 20, 0, 64, null);
                }
                if (SpiritOreConfig.STEEL.isEnabled()) {
                    this.generateOre(world, random, xBase, zBase, SpiritOres.steelOre, 5, 20, 0, 42, null);
                }
                if (!SpiritOreConfig.SPIRIT.isEnabled()) break;
                this.generateOre(world, random, xBase, zBase, SpiritOres.spiritOre, 3, 20, 0, 20, null);
                break;
            }
            case 1: {
                if (SpiritOreConfig.IRIDITE.isEnabled()) {
                    this.generateOre(world, random, xBase, zBase, SpiritOres.iriditeOre, 7, 5, 10, 64, "end_stone");
                }
                if (SpiritOreConfig.LILITHITE.isEnabled()) {
                    this.generateOre(world, random, xBase, zBase, SpiritOres.lilithiteOre, 7, 5, 10, 64, "end_stone");
                }
                if (SpiritOreConfig.ENDESPIRIT.isEnabled()) {
                    this.generateOre(world, random, xBase, zBase, SpiritOres.enderspiritOre, 5, 3, 10, 64, "end_stone");
                }
                if (!SpiritOreConfig.TELENIUM.isEnabled()) break;
                this.generateOre(world, random, xBase, zBase, SpiritOres.teleniumOre, 7, 4, 10, 64, "end_stone");
            }
        }
        ci.cancel();
    }

    private void generateOre(World world, Random random, int xBase, int zBase, Block oreBlock, int veinSize, int iterations, int minY, int maxY, String targetBlockName) {
        WorldGenMinable generator = targetBlockName != null ? new WorldGenMinable(oreBlock, veinSize, (Block)Block.field_149771_c.func_82594_a(targetBlockName)) : new WorldGenMinable(oreBlock, veinSize);
        for (int i = 0; i < iterations; ++i) {
            int x = xBase + random.nextInt(16);
            int y = minY + random.nextInt(maxY - minY + 1);
            int z = zBase + random.nextInt(16);
            generator.func_76484_a(world, random, x, y, z);
        }
    }
}

