/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.steamcraft2;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.init.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import steamcraft.common.init.InitBlocks;
import steamcraft.common.worldgen.trees.WorldGenBrassTree;

@Mixin(value={WorldGenBrassTree.class})
public class MixinFixCascadingFromWorldGenBrassTree {
    @Inject(method={"func_76484_a"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void onGenerate(World world, Random rand, int x, int y, int z, CallbackInfoReturnable<Boolean> cir) {
        int l = rand.nextInt(3) + rand.nextInt(2) + 6;
        boolean flag = true;
        if (y >= 1 && y + l + 1 <= 256) {
            int k1;
            int j1;
            for (int i1 = y; i1 <= y + 1 + l; ++i1) {
                int b0 = 1;
                if (i1 == y) {
                    b0 = 0;
                }
                if (i1 >= y + 1 + l - 2) {
                    b0 = 2;
                }
                for (j1 = x - b0; j1 <= x + b0 && flag; ++j1) {
                    for (k1 = z - b0; k1 <= z + b0 && flag; ++k1) {
                        if (i1 >= 0 && i1 < 256) {
                            world.func_147439_a(j1, i1, k1);
                            if (this.optimizationsAndTweaks$isReplaceable(world, j1, i1, k1)) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                cir.setReturnValue((Object)false);
            } else {
                Block block2 = world.func_147439_a(x, y - 1, z);
                boolean isSoil = block2.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
                if (isSoil && y < 256 - l - 1) {
                    int l3;
                    int k2;
                    int j2;
                    this.optimizationsAndTweaks$onPlantGrow(world, x, y - 1, z, x, y, z);
                    this.optimizationsAndTweaks$onPlantGrow(world, x + 1, y - 1, z, x, y, z);
                    this.optimizationsAndTweaks$onPlantGrow(world, x + 1, y - 1, z + 1, x, y, z);
                    this.optimizationsAndTweaks$onPlantGrow(world, x, y - 1, z + 1, x, y, z);
                    int j3 = rand.nextInt(4);
                    j1 = l - rand.nextInt(4);
                    k1 = 2 - rand.nextInt(3);
                    int k3 = x;
                    int l1 = z;
                    int i2 = 0;
                    for (j2 = 0; j2 < l; ++j2) {
                        Block block1;
                        k2 = y + j2;
                        if (j2 >= j1 && k1 > 0) {
                            k3 += Direction.field_71583_a[j3];
                            l1 += Direction.field_71581_b[j3];
                            --k1;
                        }
                        if (!(block1 = world.func_147439_a(k3, k2, l1)).isAir((IBlockAccess)world, k3, k2, l1) && !block1.isLeaves((IBlockAccess)world, k3, k2, l1)) continue;
                        this.optimizationsAndTweaks$setBlockAndNotifyAdequately(world, k3, k2, l1, InitBlocks.blockBrassLog, 0);
                        this.optimizationsAndTweaks$setBlockAndNotifyAdequately(world, k3 + 1, k2, l1, InitBlocks.blockBrassLog, 0);
                        this.optimizationsAndTweaks$setBlockAndNotifyAdequately(world, k3, k2, l1 + 1, InitBlocks.blockBrassLog, 0);
                        this.optimizationsAndTweaks$setBlockAndNotifyAdequately(world, k3 + 1, k2, l1 + 1, InitBlocks.blockBrassLog, 0);
                        i2 = k2;
                    }
                    for (j2 = -2; j2 <= 0; ++j2) {
                        for (k2 = -2; k2 <= 0; ++k2) {
                            l3 = -1;
                            this.optimizationsAndTweaks$setBlockAndNotifyAdequately(world, k3 + j2, i2 + l3, l1 + k2, InitBlocks.blockBrassLeaves, 0);
                            this.optimizationsAndTweaks$setBlockAndNotifyAdequately(world, 1 + k3 - j2, i2 + l3, l1 + k2, InitBlocks.blockBrassLeaves, 0);
                            this.optimizationsAndTweaks$setBlockAndNotifyAdequately(world, k3 + j2, i2 + l3, 1 + l1 - k2, InitBlocks.blockBrassLeaves, 0);
                            this.optimizationsAndTweaks$setBlockAndNotifyAdequately(world, 1 + k3 - j2, i2 + l3, 1 + l1 - k2, InitBlocks.blockBrassLeaves, 0);
                            if (j2 <= -2 && k2 <= -1 || j2 == -1 && k2 == -2) continue;
                            int l2 = 1;
                            this.optimizationsAndTweaks$setBlockAndNotifyAdequately(world, k3 + j2, i2 + l2, l1 + k2, InitBlocks.blockBrassLeaves, 0);
                            this.optimizationsAndTweaks$setBlockAndNotifyAdequately(world, 1 + k3 - j2, i2 + l2, l1 + k2, InitBlocks.blockBrassLeaves, 0);
                            this.optimizationsAndTweaks$setBlockAndNotifyAdequately(world, k3 + j2, i2 + l2, 1 + l1 - k2, InitBlocks.blockBrassLeaves, 0);
                            this.optimizationsAndTweaks$setBlockAndNotifyAdequately(world, 1 + k3 - j2, i2 + l2, 1 + l1 - k2, InitBlocks.blockBrassLeaves, 0);
                        }
                    }
                    if (rand.nextBoolean()) {
                        this.optimizationsAndTweaks$setBlockAndNotifyAdequately(world, k3, i2 + 2, l1, InitBlocks.blockBrassLeaves, 0);
                        this.optimizationsAndTweaks$setBlockAndNotifyAdequately(world, k3 + 1, i2 + 2, l1, InitBlocks.blockBrassLeaves, 0);
                        this.optimizationsAndTweaks$setBlockAndNotifyAdequately(world, k3 + 1, i2 + 2, l1 + 1, InitBlocks.blockBrassLeaves, 0);
                        this.optimizationsAndTweaks$setBlockAndNotifyAdequately(world, k3, i2 + 2, l1 + 1, InitBlocks.blockBrassLeaves, 0);
                    }
                    for (j2 = -3; j2 <= 4; ++j2) {
                        for (k2 = -3; k2 <= 4; ++k2) {
                            if (j2 == -3 && k2 == -3 || j2 == -3 && k2 == 4 || j2 == 4 && k2 == -3 || j2 == 4 && k2 == 4 || Math.abs(j2) >= 3 && Math.abs(k2) >= 3) continue;
                            this.optimizationsAndTweaks$setBlockAndNotifyAdequately(world, k3 + j2, i2, l1 + k2, InitBlocks.blockBrassLeaves, 0);
                        }
                    }
                    for (j2 = -1; j2 <= 2; ++j2) {
                        for (k2 = -1; k2 <= 2; ++k2) {
                            int i3;
                            int l2;
                            if (j2 >= 0 && j2 <= 1 && k2 >= 0 && k2 <= 1 || rand.nextInt(3) > 0) continue;
                            l3 = rand.nextInt(3) + 2;
                            for (l2 = 0; l2 < l3; ++l2) {
                                this.optimizationsAndTweaks$setBlockAndNotifyAdequately(world, x + j2, i2 - l2 - 1, z + k2, InitBlocks.blockBrassLog, 0);
                            }
                            for (l2 = -1; l2 <= 1; ++l2) {
                                for (i3 = -1; i3 <= 1; ++i3) {
                                    this.optimizationsAndTweaks$setBlockAndNotifyAdequately(world, k3 + j2 + l2, i2 - 0, l1 + k2 + i3, InitBlocks.blockBrassLeaves, 0);
                                }
                            }
                            for (l2 = -2; l2 <= 2; ++l2) {
                                for (i3 = -2; i3 <= 2; ++i3) {
                                    if (Math.abs(l2) == 2 && Math.abs(i3) == 2) continue;
                                    this.optimizationsAndTweaks$setBlockAndNotifyAdequately(world, k3 + j2 + l2, i2 - 1, l1 + k2 + i3, InitBlocks.blockBrassLeaves, 0);
                                }
                            }
                        }
                    }
                    cir.setReturnValue((Object)true);
                } else {
                    cir.setReturnValue((Object)false);
                }
            }
        } else {
            cir.setReturnValue((Object)false);
        }
    }

    @Unique
    private void optimizationsAndTweaks$setBlockAndNotifyAdequately(World world, int x, int y, int z, Block block, int metadata) {
        world.func_147465_d(x, y, z, block, metadata, 3);
        world.func_147444_c(x, y, z, block);
    }

    @Unique
    private void optimizationsAndTweaks$onPlantGrow(World world, int x, int y, int z, int sourceX, int sourceY, int sourceZ) {
        world.func_147439_a(x, y, z).onPlantGrow(world, x, y, z, sourceX, sourceY, sourceZ);
    }

    @Unique
    private boolean optimizationsAndTweaks$isReplaceable(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block.isReplaceable((IBlockAccess)world, x, y, z);
    }
}

