/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.witchery;

import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.common.ExtendedPlayer;
import com.emoniph.witchery.common.GenericEvents;
import com.emoniph.witchery.entity.ai.EntityAIDigBlocks;
import com.emoniph.witchery.network.PacketHowl;
import com.emoniph.witchery.network.PacketSelectPlayerAbility;
import com.emoniph.witchery.util.TransformCreature;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={GenericEvents.class})
public class MixinGenericEventsWitchery {
    @Overwrite(remap=false)
    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        this.optimizationsAndTweaks$handlePlayerInteract(event);
    }

    @Unique
    private void optimizationsAndTweaks$handlePlayerInteract(PlayerInteractEvent event) {
        if (event.entityPlayer == null) {
            return;
        }
        ExtendedPlayer playerEx = ExtendedPlayer.get((EntityPlayer)event.entityPlayer);
        if (playerEx == null) {
            return;
        }
        if (this.optimizationsAndTweaks$handleVampirePowers(event, playerEx)) {
            return;
        }
        if (this.optimizationsAndTweaks$handleHowling(event, playerEx)) {
            return;
        }
        if (this.optimizationsAndTweaks$handleBlockInteractions(event, playerEx)) {
            return;
        }
    }

    @Unique
    private boolean optimizationsAndTweaks$handleVampirePowers(PlayerInteractEvent event, ExtendedPlayer playerEx) {
        if (playerEx.getSelectedVampirePower() != ExtendedPlayer.VampirePower.NONE && (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR || event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK)) {
            switch (playerEx.getSelectedVampirePower()) {
                case MESMERIZE: 
                case SPEED: 
                case BAT: 
                case ULTIMATE: {
                    Witchery.packetPipeline.sendToServer((IMessage)new PacketSelectPlayerAbility(playerEx, true));
                    return true;
                }
            }
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    @Unique
    private boolean optimizationsAndTweaks$handleHowling(PlayerInteractEvent event, ExtendedPlayer playerEx) {
        if (event.entityPlayer.field_70170_p.field_72995_K && (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR || event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) && event.entityPlayer.field_70125_A == -90.0f && event.entityPlayer.func_70093_af()) {
            Witchery.packetPipeline.sendToServer((IMessage)new PacketHowl());
            return true;
        }
        return false;
    }

    @Unique
    private boolean optimizationsAndTweaks$handleBlockInteractions(PlayerInteractEvent event, ExtendedPlayer playerEx) {
        if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && !event.entityPlayer.field_71075_bZ.field_75098_d) {
            if (this.optimizationsAndTweaks$handleGarlicGarland(event, playerEx)) {
                return true;
            }
            return this.optimizationsAndTweaks$handleHarvestingBlocks(event, playerEx);
        }
        return false;
    }

    @Unique
    private boolean optimizationsAndTweaks$handleGarlicGarland(PlayerInteractEvent event, ExtendedPlayer playerEx) {
        if (playerEx.isVampire() && event.world.func_147439_a(event.x, event.y, event.z) == Witchery.Blocks.GARLIC_GARLAND) {
            event.entityPlayer.func_70015_d(1);
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    @Unique
    private boolean optimizationsAndTweaks$handleHarvestingBlocks(PlayerInteractEvent event, ExtendedPlayer playerEx) {
        Block block;
        if (playerEx.getCreatureType() == TransformCreature.WOLF && playerEx.getWerewolfLevel() >= 3 && event.entityPlayer.func_70093_af()) {
            Block block2 = event.world.func_147439_a(event.x, event.y, event.z);
            if (block2 == Blocks.field_150349_c || block2 == Blocks.field_150354_m || block2 == Blocks.field_150346_d || block2 == Blocks.field_150391_bh || block2 == Blocks.field_150351_n) {
                EntityAIDigBlocks.tryHarvestBlock((World)event.world, (int)event.x, (int)event.y, (int)event.z, (EntityLivingBase)event.entityPlayer, (EntityPlayer)event.entityPlayer);
                event.setCanceled(true);
                return true;
            }
        } else if (!(playerEx.getVampireLevel() < 6 || playerEx.getCreatureType() != TransformCreature.NONE || !event.entityPlayer.func_70093_af() || event.entityPlayer.func_70694_bm() != null && Objects.requireNonNull(event.entityPlayer.func_70694_bm().func_77973_b()).func_150897_b(Blocks.field_150348_b) || event.entityPlayer.func_71024_bL().func_75116_a() <= 0 || (block = event.world.func_147439_a(event.x, event.y, event.z)) != Blocks.field_150348_b && block != Blocks.field_150424_aL && block != Blocks.field_150347_e)) {
            EntityAIDigBlocks.tryHarvestBlock((World)event.world, (int)event.x, (int)event.y, (int)event.z, (EntityLivingBase)event.entityPlayer, (EntityPlayer)event.entityPlayer);
            event.entityPlayer.func_71020_j(10.0f);
            event.setCanceled(true);
            return true;
        }
        return false;
    }
}

