/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.mixins.common.netherlicious;

import DelirusCrux.Netherlicious.Common.BlockItemUtility.ModBlocks;
import DelirusCrux.Netherlicious.World.Features.Terrain.RuptureSpike;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={RuptureSpike.class})
public abstract class MixinRuptureSpike
extends WorldGenerator {
    @Shadow
    private int minWidth;
    @Shadow
    private int maxWidth;
    @Shadow
    private int MinHeight;
    @Shadow
    private int Height;

    @Overwrite(remap=false)
    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        world.func_72807_a(i, k);
        int boulderWidth = MathHelper.func_76136_a((Random)random, (int)this.minWidth, (int)this.maxWidth);
        int spheres = 1 + random.nextInt(boulderWidth + 1);
        for (int l = 0; l < spheres; ++l) {
            int posX = i + MathHelper.func_76136_a((Random)random, (int)(-boulderWidth), (int)boulderWidth);
            int posZ = k + MathHelper.func_76136_a((Random)random, (int)(-boulderWidth), (int)boulderWidth);
            int posY = this.MinHeight + random.nextInt(this.Height);
            int sphereWidth = MathHelper.func_76136_a((Random)random, (int)this.minWidth, (int)this.maxWidth);
            this.optimizationsAndTweaks$processSphere(world, random, posX, posY, posZ, sphereWidth);
        }
        return true;
    }

    @Unique
    private void optimizationsAndTweaks$processSphere(World world, Random random, int posX, int posY, int posZ, int sphereWidth) {
        for (int i1 = posX - sphereWidth; i1 <= posX + sphereWidth; ++i1) {
            for (int j1 = posY - sphereWidth; j1 <= posY + sphereWidth; ++j1) {
                for (int k1 = posZ - sphereWidth; k1 <= posZ + sphereWidth; ++k1) {
                    this.optimizationsAndTweaks$checkSphereArea(world, i1, j1, k1, sphereWidth, random);
                }
            }
        }
    }

    @Unique
    private void optimizationsAndTweaks$checkSphereArea(World world, int i1, int j1, int k1, int sphereWidth, Random random) {
        int dist = i1 * i1 + j1 * j1 + k1 * k1;
        if (dist < sphereWidth * sphereWidth || dist < (sphereWidth + 1) * (sphereWidth + 1) && random.nextInt(3) == 0) {
            for (int j3 = j1; j3 >= 0 && world.func_72904_c(i1, j3, k1, i1, j3, k1); --j3) {
                if (!this.optimizationsAndTweaks$isOpaqueCube(world, i1, j3, k1) || this.optimizationsAndTweaks$isLava(world, i1, j3, k1)) {
                    continue;
                }
                if (!this.optimizationsAndTweaks$isAirOrNetherBrick(world, i1, j3, k1) && !this.optimizationsAndTweaks$isLavaMaterial(world, i1, j3, k1)) break;
                this.placeRandomBlackstone(world, random, i1, j3, k1);
                break;
            }
        }
    }

    @Unique
    private boolean optimizationsAndTweaks$isOpaqueCube(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).func_149662_c();
    }

    @Unique
    private boolean optimizationsAndTweaks$isLava(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == Blocks.field_150353_l;
    }

    @Unique
    private boolean optimizationsAndTweaks$isAirOrNetherBrick(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == Blocks.field_150350_a && world.func_147439_a(x, y - 1, z) != Blocks.field_150385_bj;
    }

    @Unique
    private boolean optimizationsAndTweaks$isLavaMaterial(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).func_149688_o().func_76224_d();
    }

    @Overwrite(remap=false)
    private void placeRandomBlackstone(World world, Random random, int x, int y, int z) {
        if (random.nextInt(7) == 0) {
            this.func_150516_a(world, x, y, z, ModBlocks.MagmaBlock, 1);
        } else {
            this.func_150516_a(world, x, y, z, Blocks.field_150424_aL, 0);
        }
    }
}

