/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.agrona.io;

import fr.iamacat.optimizationsandtweaks.utils.agrona.DirectBuffer;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;

public class DirectBufferDataInput
implements DataInput {
    private DirectBuffer buffer;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private int length;
    private int position;

    public DirectBufferDataInput(DirectBuffer buffer) {
        this.wrap(buffer, 0, buffer.capacity());
    }

    public DirectBufferDataInput(DirectBuffer buffer, int offset, int length) {
        this.wrap(buffer, offset, length);
    }

    public void wrap(DirectBuffer buffer) {
        this.wrap(buffer, 0, buffer.capacity());
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        if (null == buffer) {
            throw new NullPointerException("buffer cannot be null");
        }
        DirectBufferDataInput.boundsCheckWrap(offset, length, buffer.capacity());
        this.buffer = buffer;
        this.length = length + offset;
        this.position = offset;
    }

    public void byteOrder(ByteOrder byteOrder) {
        if (null == byteOrder) {
            throw new IllegalArgumentException("byteOrder cannot be null");
        }
        this.byteOrder = byteOrder;
    }

    public int remaining() {
        return this.length - this.position;
    }

    @Override
    public void readFully(byte[] destination) throws EOFException {
        if (destination == null) {
            throw new NullPointerException("Destination must not be null");
        }
        this.readFully(destination, 0, destination.length);
    }

    @Override
    public void readFully(byte[] destination, int destinationOffset, int length) throws EOFException {
        if (destination == null) {
            throw new NullPointerException("Destination must not be null");
        }
        if (destinationOffset < 0) {
            throw new IndexOutOfBoundsException("invalid destinationOffset: " + destinationOffset);
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("invalid length: " + length);
        }
        if (destinationOffset + length > destination.length) {
            throw new IndexOutOfBoundsException("destinationOffset=" + destinationOffset + " length=" + length + " not valid for length=" + length);
        }
        this.boundsCheck0(length);
        this.buffer.getBytes(this.position, destination, destinationOffset, length);
        this.position += length;
    }

    @Override
    public int skipBytes(int n) {
        int toSkip = Math.min(n, this.remaining());
        this.position += toSkip;
        return toSkip;
    }

    @Override
    public boolean readBoolean() throws EOFException {
        this.boundsCheck0(1);
        return this.buffer.getByte(this.position++) != 0;
    }

    @Override
    public byte readByte() throws EOFException {
        this.boundsCheck0(1);
        return this.buffer.getByte(this.position++);
    }

    @Override
    public int readUnsignedByte() throws EOFException {
        this.boundsCheck0(1);
        return this.buffer.getByte(this.position++) & 0xFF;
    }

    @Override
    public short readShort() throws EOFException {
        this.boundsCheck0(2);
        short result = this.buffer.getShort(this.position, this.byteOrder);
        this.position += 2;
        return result;
    }

    @Override
    public int readUnsignedShort() throws EOFException {
        this.boundsCheck0(2);
        int result = this.buffer.getShort(this.position, this.byteOrder) & 0xFFFF;
        this.position += 2;
        return result;
    }

    @Override
    public char readChar() throws EOFException {
        this.boundsCheck0(2);
        char result = this.buffer.getChar(this.position, this.byteOrder);
        this.position += 2;
        return result;
    }

    @Override
    public int readInt() throws EOFException {
        this.boundsCheck0(4);
        int result = this.buffer.getInt(this.position, this.byteOrder);
        this.position += 4;
        return result;
    }

    @Override
    public long readLong() throws EOFException {
        this.boundsCheck0(8);
        long result = this.buffer.getLong(this.position, this.byteOrder);
        this.position += 8;
        return result;
    }

    @Override
    public float readFloat() throws EOFException {
        this.boundsCheck0(4);
        float result = this.buffer.getFloat(this.position, this.byteOrder);
        this.position += 4;
        return result;
    }

    @Override
    public double readDouble() throws EOFException {
        this.boundsCheck0(8);
        double result = this.buffer.getDouble(this.position, this.byteOrder);
        this.position += 8;
        return result;
    }

    @Override
    public String readLine() throws IOException {
        if (this.remaining() == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        this.readLine(result);
        return result.toString();
    }

    public int readLine(Appendable appendable) throws IOException {
        int startingPosition = this.position;
        while (this.remaining() > 0) {
            byte nextByte = this.readByte();
            if (nextByte == 10) {
                return this.position - startingPosition;
            }
            if (nextByte == 13) {
                byte peek;
                if (this.remaining() > 0 && (peek = this.readByte()) != 10) {
                    this.skipBytes(-1);
                }
                return this.position - startingPosition;
            }
            appendable.append((char)nextByte);
        }
        return this.position - startingPosition;
    }

    @Override
    public String readUTF() throws EOFException {
        this.boundsCheck0(2);
        short size = this.readShort();
        this.boundsCheck0(size);
        String stringUtf8 = this.buffer.getStringWithoutLengthUtf8(this.position, size);
        this.position += size;
        return stringUtf8;
    }

    public String readStringUTF8() {
        String stringUtf8 = this.buffer.getStringUtf8(this.position, this.byteOrder);
        this.position += stringUtf8.length();
        return stringUtf8;
    }

    public String readStringAscii() {
        String stringAscii = this.buffer.getStringAscii(this.position, this.byteOrder);
        this.position += stringAscii.length();
        return stringAscii;
    }

    public int readStringAscii(Appendable appendable) {
        int bytesRead = this.buffer.getStringAscii(this.position, appendable, this.byteOrder);
        this.position += bytesRead;
        return bytesRead;
    }

    private void boundsCheck0(int requestedReadBytes) throws EOFException {
        long resultingPosition = this.position + requestedReadBytes;
        if (resultingPosition > (long)this.length) {
            throw new EOFException("position=" + this.position + " requestedReadBytes=" + requestedReadBytes + " capacity=" + this.length);
        }
    }

    private static void boundsCheckWrap(int offset, int length, int capacity) {
        if (offset < 0) {
            throw new IllegalArgumentException("invalid offset: " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("invalid length: " + length);
        }
        if (offset > capacity - length || length > capacity - offset) {
            throw new IllegalArgumentException("offset=" + offset + " length=" + length + " not valid for capacity=" + capacity);
        }
    }
}

