/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.optimizationsandtweaks.collections.maps;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;

public class ConcurrentSkipListSetThreadSafe<E>
extends ConcurrentSkipListSet<E> {
    private static final long serialVersionUID = -2479143111061671589L;
    private final ConcurrentNavigableMap<E, Object> m;

    public ConcurrentSkipListSetThreadSafe() {
        this.m = new ConcurrentSkipListMap<E, Object>();
    }

    public ConcurrentSkipListSetThreadSafe(Comparator<? super E> var1) {
        this.m = new ConcurrentSkipListMap<E, Object>(var1);
    }

    public ConcurrentSkipListSetThreadSafe(Collection<? extends E> var1) {
        this.m = new ConcurrentSkipListMap<E, Object>();
        this.addAll(var1);
    }

    public ConcurrentSkipListSetThreadSafe(SortedSet<E> var1) {
        this.m = new ConcurrentSkipListMap<E, Object>(var1.comparator());
        this.addAll(var1);
    }

    ConcurrentSkipListSetThreadSafe(ConcurrentNavigableMap<E, Object> var1) {
        this.m = var1;
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public boolean contains(Object var1) {
        return this.m.containsKey(var1);
    }

    @Override
    public boolean add(E var1) {
        return this.m.putIfAbsent(var1, Boolean.TRUE) == null;
    }

    @Override
    public boolean remove(Object var1) {
        return this.m.remove(var1, Boolean.TRUE);
    }

    @Override
    public void clear() {
        this.m.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return this.m.keySet().iterator();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.m.descendingKeySet().iterator();
    }

    @Override
    public boolean equals(Object var1) {
        if (var1 == this) {
            return true;
        }
        if (!(var1 instanceof Set)) {
            return false;
        }
        Collection var2 = (Collection)var1;
        try {
            return this.containsAll(var2) && var2.containsAll(this);
        }
        catch (ClassCastException var4) {
            return false;
        }
        catch (NullPointerException var5) {
            return false;
        }
    }

    @Override
    public boolean removeAll(Collection<?> var1) {
        boolean var2 = false;
        for (Object var4 : var1) {
            if (!this.remove(var4)) continue;
            var2 = true;
        }
        return var2;
    }

    @Override
    public E lower(E var1) {
        return this.m.lowerKey(var1);
    }

    @Override
    public E floor(E var1) {
        return this.m.floorKey(var1);
    }

    @Override
    public E ceiling(E var1) {
        return this.m.ceilingKey(var1);
    }

    @Override
    public E higher(E var1) {
        return this.m.higherKey(var1);
    }

    @Override
    public E pollFirst() {
        Map.Entry var1 = this.m.pollFirstEntry();
        return var1 == null ? null : (E)var1.getKey();
    }

    @Override
    public E pollLast() {
        Map.Entry var1 = this.m.pollLastEntry();
        return var1 == null ? null : (E)var1.getKey();
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.m.comparator();
    }

    @Override
    public E first() {
        return (E)this.m.firstKey();
    }

    @Override
    public E last() {
        return (E)this.m.lastKey();
    }

    @Override
    public NavigableSet<E> subSet(E var1, boolean var2, E var3, boolean var4) {
        return new ConcurrentSkipListSetThreadSafe<E>(this.m.subMap((Object)var1, var2, (Object)var3, var4));
    }

    @Override
    public NavigableSet<E> headSet(E var1, boolean var2) {
        return new ConcurrentSkipListSetThreadSafe<E>(this.m.headMap((Object)var1, var2));
    }

    @Override
    public NavigableSet<E> tailSet(E var1, boolean var2) {
        return new ConcurrentSkipListSetThreadSafe<E>(this.m.tailMap((Object)var1, var2));
    }

    @Override
    public NavigableSet<E> subSet(E var1, E var2) {
        return this.subSet(var1, true, var2, false);
    }

    @Override
    public NavigableSet<E> headSet(E var1) {
        return this.headSet(var1, false);
    }

    @Override
    public NavigableSet<E> tailSet(E var1) {
        return this.tailSet(var1, true);
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return new ConcurrentSkipListSetThreadSafe<E>(this.m.descendingMap());
    }
}

