/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.optimizationsandtweaks.utils.pathfinding;

import net.minecraft.pathfinding.PathEntity;

public class CachedPath {
    final PathEntity path;
    final double entityX;
    final double entityY;
    final double entityZ;
    final double targetX;
    final double targetY;
    final double targetZ;
    final long timestamp;

    public CachedPath(PathEntity path, double entityX, double entityY, double entityZ, double targetX, double targetY, double targetZ, long timestamp) {
        this.path = path;
        this.entityX = entityX;
        this.entityY = entityY;
        this.entityZ = entityZ;
        this.targetX = targetX;
        this.targetY = targetY;
        this.targetZ = targetZ;
        this.timestamp = timestamp;
    }

    public PathEntity getPath() {
        return this.path;
    }

    public boolean isValid(double curEntityX, double curEntityY, double curEntityZ, double curTargetX, double curTargetY, double curTargetZ, long currentTime) {
        if (currentTime - this.timestamp > 600L) {
            return false;
        }
        double entityDist = CachedPath.distanceSquared(this.entityX, this.entityY, this.entityZ, curEntityX, curEntityY, curEntityZ);
        if (entityDist > 0.36) {
            return false;
        }
        double targetDist = CachedPath.distanceSquared(this.targetX, this.targetY, this.targetZ, curTargetX, curTargetY, curTargetZ);
        return !(targetDist > 1.44);
    }

    private static double distanceSquared(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        return dx * dx + dy * dy + dz * dz;
    }
}

