/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.common.gui;

import imgui.ImGui;
import imgui.ImGuiInputTextCallbackData;
import imgui.ImVec2;
import imgui.callback.ImGuiInputTextCallback;
import imgui.internal.ImGuiWindow;
import io.github.reserveword.imblocker.common.IMManager;
import io.github.reserveword.imblocker.common.ReflectionUtil;
import io.github.reserveword.imblocker.common.StringUtil;
import io.github.reserveword.imblocker.common.gui.FocusContainer;
import io.github.reserveword.imblocker.common.gui.FocusableWidget;
import io.github.reserveword.imblocker.common.gui.Point;
import io.github.reserveword.imblocker.common.gui.Rectangle;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class GenericAxiomTextField
implements FocusableWidget {
    private static final GenericAxiomTextField INSTANCE = new GenericAxiomTextField();
    private static final AxiomTextFieldCallback axiomTextFieldCallback = new AxiomTextFieldCallback();
    private static boolean isMultiline = false;
    private static int currentItemId = 0;
    private static int activeItemId = 0;
    private static String itemLabel = "";
    private static int fontHeight = 8;
    private static Rectangle bounds = Rectangle.EMPTY;
    private static Point caretPos = Point.TOP_LEFT;
    private static int inputTextFlags = 0;
    private static float internalScrollX = 0.0f;
    private static String text = "";
    private static String textBeforeCursor = "";
    private static float cursorX = 0.0f;
    private static int[] lineData = new int[]{0};
    private static int[] beginIndexData = new int[]{0};

    @Override
    public Rectangle getBoundsAbs() {
        return bounds;
    }

    @Override
    public Point getCaretPos() {
        return caretPos;
    }

    @Override
    public int getFontHeight() {
        return fontHeight;
    }

    @Override
    public FocusContainer getFocusContainer() {
        return FocusContainer.IMGUI;
    }

    public static GenericAxiomTextField getInstance() {
        return INSTANCE;
    }

    public static ImGuiInputTextCallback getAxiomTextFieldCallback(ImGuiInputTextCallback present) {
        AxiomTextFieldCallback.nested = present;
        return axiomTextFieldCallback;
    }

    public static void setMultiline(boolean multiline) {
        isMultiline = multiline;
    }

    public static void setLabel(String label) {
        currentItemId = ImGui.getID((String)label);
        itemLabel = label;
    }

    public static void setInputTextFlags(int flags) {
        inputTextFlags = flags;
    }

    private static void updateTextFieldGUIProperties(ImGuiInputTextCallbackData axiomTextFieldData) {
        Point currentCaretPos;
        int currentFontHeight = ImGui.getFontSize();
        ImVec2 pos = ImGui.getItemRectMin();
        ImVec2 size = ImGui.getItemRectSize();
        Rectangle currentBounds = new Rectangle((int)pos.x, (int)pos.y, (int)size.x, Integer.MAX_VALUE);
        if (axiomTextFieldData != null) {
            int cursorPos;
            String currentTextBeforeCursor;
            String currentText = axiomTextFieldData.getBuf();
            if (!text.equals(currentText)) {
                text = currentText;
                GenericAxiomTextField.splitLines(text);
            }
            if (!textBeforeCursor.equals(currentTextBeforeCursor = StringUtil.getSubstring(text, beginIndexData[cursorPos = new String(Arrays.copyOfRange(currentText.getBytes(StandardCharsets.UTF_8), 0, axiomTextFieldData.getCursorPos()), StandardCharsets.UTF_8).length()], cursorPos))) {
                textBeforeCursor = currentTextBeforeCursor;
                cursorX = ImGui.calcTextSize((String)GenericAxiomTextField.textBeforeCursor).x;
                GenericAxiomTextField.updateInternalScrollX(cursorX);
            }
            int caretX = (int)(ImGui.getStyle().getFramePaddingX() + cursorX - internalScrollX - ImGui.getScrollX());
            int caretY = (int)(ImGui.getStyle().getFramePaddingY() + (float)(lineData[cursorPos] * currentFontHeight) - ImGui.getScrollY());
            currentCaretPos = new Point(caretX, caretY);
        } else {
            currentCaretPos = Point.TOP_LEFT;
        }
        if (!bounds.equals(currentBounds) || !caretPos.equals(currentCaretPos)) {
            bounds = currentBounds;
            caretPos = currentCaretPos;
            IMManager.updateCompositionWindowPos();
        }
        if (fontHeight != currentFontHeight) {
            fontHeight = currentFontHeight;
            IMManager.updateCompositionFontSize();
        }
    }

    private static void updateInternalScrollX(float cursorOffsetX) {
        if (activeItemId != currentItemId) {
            activeItemId = currentItemId;
            internalScrollX = 0.0f;
        }
        float innerWidth = ImGui.getItemRectSizeX();
        if (!isMultiline) {
            float labelWidth;
            if (!itemLabel.startsWith("##") && (labelWidth = ImGui.calcTextSize((String)GenericAxiomTextField.itemLabel, (boolean)true).x) > 0.0f) {
                innerWidth -= labelWidth + ImGui.getStyle().getItemInnerSpacingX();
            }
        } else if (GenericAxiomTextField.hasVerticalScrollBar()) {
            innerWidth -= ImGui.getStyle().getScrollbarSize();
        }
        if ((inputTextFlags & 0x1000) == 0) {
            float scrollIncrementX = innerWidth * 0.25f;
            float visibleWidth = innerWidth - ImGui.getStyle().getFramePaddingX();
            if (cursorOffsetX < internalScrollX) {
                internalScrollX = (float)Math.floor(Math.max(0.0f, cursorOffsetX - scrollIncrementX));
            } else if (cursorOffsetX - visibleWidth >= internalScrollX) {
                internalScrollX = (float)Math.floor(cursorOffsetX - visibleWidth + scrollIncrementX);
            }
        } else {
            internalScrollX = 0.0f;
        }
    }

    private static boolean hasVerticalScrollBar() {
        try {
            ImGuiWindow currentWindow = imgui.internal.ImGui.getCurrentWindow();
            try {
                return currentWindow.getScrollbarY();
            }
            catch (NoSuchMethodError e) {
                return ReflectionUtil.invokeMethod(ImGuiWindow.class, currentWindow, Boolean.TYPE, "isScrollbarY", new Class[0], new Object[0]);
            }
        }
        catch (Throwable e) {
            try {
                return ImGui.getScrollMaxY() > 0.0f;
            }
            catch (Throwable e2) {
                return false;
            }
        }
    }

    private static void splitLines(String text) {
        lineData = new int[text.length() + 1];
        beginIndexData = new int[text.length() + 1];
        int currentLine = 0;
        int currentLineBeginIndex = 0;
        for (int charIndex = 0; charIndex < text.length(); ++charIndex) {
            GenericAxiomTextField.lineData[charIndex] = currentLine++;
            GenericAxiomTextField.beginIndexData[charIndex] = currentLineBeginIndex;
            char currentChar = text.charAt(charIndex);
            if (currentChar != '\n') continue;
            currentLineBeginIndex = charIndex + 1;
        }
        GenericAxiomTextField.lineData[charIndex] = currentLine;
        GenericAxiomTextField.beginIndexData[charIndex] = currentLineBeginIndex;
    }

    private static class AxiomTextFieldCallback
    extends ImGuiInputTextCallback {
        private static ImGuiInputTextCallback nested;

        private AxiomTextFieldCallback() {
        }

        public void accept(ImGuiInputTextCallbackData t) {
            if (nested != null) {
                nested.accept((Object)t);
            }
            if ((t.getEventFlag() & 0x40000) == 0) {
                if (!INSTANCE.isTrulyFocused()) {
                    FocusContainer.IMGUI.requestFocus(INSTANCE);
                }
                GenericAxiomTextField.updateTextFieldGUIProperties(t);
            }
        }
    }
}

