/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.mixin;

import io.github.reserveword.imblocker.common.gui.FocusContainer;
import io.github.reserveword.imblocker.common.gui.FocusManager;
import io.github.reserveword.imblocker.common.gui.MinecraftTextFieldWidget;
import io.github.reserveword.imblocker.common.gui.SinglelineCursorInfo;
import io.github.reserveword.imblocker.mixin.AbstractWidgetMixin;
import net.minecraft.client.gui.components.EditBox;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EditBox.class})
public abstract class TextFieldMixin
extends AbstractWidgetMixin
implements MinecraftTextFieldWidget {
    @Shadow
    private boolean isEditable;
    @Shadow
    private boolean bordered;
    @Shadow
    private int displayPos;
    @Shadow
    private int cursorPos;
    @Shadow
    private String value;
    private final SinglelineCursorInfo imblocker$cursorInfo;
    private boolean preferredEnglishState;
    @Unique
    private boolean isRenderable;
    @Unique
    private long lastRenderTime;

    public TextFieldMixin() {
        this.imblocker$cursorInfo = new SinglelineCursorInfo(this.bordered, this.height, this.displayPos, this.cursorPos, this.value);
        this.preferredEnglishState = this.getPrimaryEnglishState();
        this.isRenderable = true;
    }

    @Shadow
    public abstract boolean canConsumeInput();

    @Override
    @Inject(method={"setFocused"}, at={@At(value="TAIL")})
    public void focusChanged(boolean isFocused, CallbackInfo ci) {
        this.imblocker$onFocusChanged(this.canConsumeInput());
    }

    @Inject(method={"setVisible"}, at={@At(value="TAIL")})
    public void visibilityChanged(boolean isVisible, CallbackInfo ci) {
        this.imblocker$onFocusChanged(this.canConsumeInput());
    }

    @Inject(method={"charTyped"}, at={@At(value="HEAD")}, cancellable=true)
    public void checkFocusTracking(char chr, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (FocusManager.isTrackingFocus) {
            if (this.canConsumeInput()) {
                FocusContainer.MINECRAFT.switchFocus(this);
                cir.setReturnValue((Object)true);
            } else {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"onValueChange"}, at={@At(value="TAIL")})
    public void onTextChanged(String newValue, CallbackInfo ci) {
        this.imblocker$onCursorChanged();
    }

    @Override
    public boolean updateCursorInfo() {
        return this.imblocker$cursorInfo.updateCursorInfo(this.bordered, this.height, this.displayPos, this.cursorPos, this.value);
    }

    @Override
    public SinglelineCursorInfo getCursorInfo() {
        return this.imblocker$cursorInfo;
    }

    @Override
    public void updateLastRenderTime(CallbackInfoReturnable<Boolean> ci) {
        if (FocusManager.isGameRendering) {
            this.lastRenderTime = System.nanoTime();
        }
    }

    @Overwrite
    public void setEditable(boolean editable) {
        if (this.isEditable != editable) {
            this.isEditable = editable;
            this.imblocker$onFocusChanged(this.canConsumeInput());
        }
    }

    @Override
    public void setPreferredEnglishState(boolean state) {
        if (this.preferredEnglishState != state) {
            this.preferredEnglishState = state;
            if (this.isTrulyFocused()) {
                this.updateEnglishState();
            }
        }
    }

    @Override
    public boolean getPreferredEnglishState() {
        return this.preferredEnglishState;
    }

    @Override
    public void checkVisibility(long lastGameRenderTime) {
        this.setRenderable(this.lastRenderTime > lastGameRenderTime);
    }

    @Unique
    private void setRenderable(boolean renderable) {
        if (this.isRenderable != renderable) {
            this.isRenderable = renderable;
            this.getFocusContainer().locateRealFocus();
        }
    }

    @Override
    @Unique
    public boolean isRenderable() {
        return this.isRenderable;
    }
}

