/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.mixin.compat;

import io.github.cottonmc.cotton.gui.widget.WTextField;
import io.github.reserveword.imblocker.common.IMBlockerCore;
import io.github.reserveword.imblocker.common.ReflectionUtil;
import io.github.reserveword.imblocker.common.gui.FocusContainer;
import io.github.reserveword.imblocker.common.gui.FocusManager;
import io.github.reserveword.imblocker.common.gui.MinecraftTextFieldWidget;
import io.github.reserveword.imblocker.common.gui.SinglelineCursorInfo;
import io.github.reserveword.imblocker.mixin.compat.LibGuiWidgetMixin;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WTextField.class}, remap=false)
public abstract class LibGuiTextFieldMixin
extends LibGuiWidgetMixin
implements MinecraftTextFieldWidget {
    @Shadow(aliases={"OFFSET_X_TEXT"})
    public static final int TEXT_PADDING_X = 4;
    @Shadow
    private String text;
    @Shadow
    private int scrollOffset;
    @Shadow
    private int cursor;
    private final SinglelineCursorInfo imblocker$cursorInfo;
    @Unique
    private static final Object PROCESSED_INPUTRESULT;

    public LibGuiTextFieldMixin() {
        this.imblocker$cursorInfo = new SinglelineCursorInfo(true, this.height, this.scrollOffset, this.cursor, this.text);
    }

    @Override
    public void handleLocationChanged(int x, int y, CallbackInfo ci) {
        this.imblocker$onBoundsChanged();
    }

    @Override
    public void handleSizeChanged(int width, int height, CallbackInfo ci) {
        this.imblocker$onBoundsChanged();
    }

    @Inject(method={"onFocusGained"}, at={@At(value="TAIL")})
    public void onFocusGained(CallbackInfo ci) {
        this.imblocker$onFocusGained();
    }

    @Override
    public void onFocusLost(CallbackInfo ci) {
        this.imblocker$onFocusLost();
    }

    @Inject(method={"onCharTyped(C)V"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    public void checkFocusTracking(char c, CallbackInfo ci) {
        if (FocusManager.isTrackingFocus) {
            FocusContainer.MINECRAFT.switchFocus(this);
            ci.cancel();
        }
    }

    @Inject(method={"onCharTyped(C)Lio/github/cottonmc/cotton/gui/widget/data/InputResult;"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    public void checkFocusTracking(char c, CallbackInfoReturnable<Object> cir) {
        if (FocusManager.isTrackingFocus) {
            FocusContainer.MINECRAFT.switchFocus(this);
            cir.setReturnValue(PROCESSED_INPUTRESULT);
        }
    }

    @Inject(method={"setText"}, at={@At(value="TAIL")})
    public void onTextChanged(String s, CallbackInfo ci) {
        this.imblocker$onCursorChanged();
    }

    @Inject(method={"getSelection"}, at={@At(value="TAIL")})
    public void onGetSelection(CallbackInfoReturnable<String> cir) {
        this.imblocker$onCursorChanged();
    }

    @Inject(method={"scrollCursorIntoView"}, at={@At(value="TAIL")})
    public void onScroll(CallbackInfo ci) {
        this.imblocker$onCursorChanged();
    }

    @Override
    public boolean updateCursorInfo() {
        return this.imblocker$cursorInfo.updateCursorInfo(true, this.height, this.scrollOffset, this.cursor, this.text);
    }

    @Override
    public SinglelineCursorInfo getCursorInfo() {
        return this.imblocker$cursorInfo;
    }

    @Override
    public int getPaddingX() {
        return 4;
    }

    static {
        Object processedInputResult = null;
        if (IMBlockerCore.isGameVersionReached(762)) {
            try {
                Class<?> inputResultClass = Class.forName("io.github.cottonmc.cotton.gui.widget.data.InputResult");
                processedInputResult = ReflectionUtil.getFieldValue(inputResultClass, null, null, "PROCESSED");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        PROCESSED_INPUTRESULT = processedInputResult;
    }
}

