/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.mixin.compat;

import io.github.reserveword.imblocker.common.IMManager;
import io.github.reserveword.imblocker.common.StringUtil;
import io.github.reserveword.imblocker.common.accessor.MinecraftClientAccessor;
import io.github.reserveword.imblocker.common.gui.FocusContainer;
import io.github.reserveword.imblocker.common.gui.FocusManager;
import io.github.reserveword.imblocker.common.gui.Point;
import io.github.reserveword.imblocker.mixin.AbstractWidgetMixin;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Pseudo
@Mixin(targets={"com.chaosthedude.notes.gui.NotesTextField"})
public abstract class NotesTextFieldMixin
extends AbstractWidgetMixin {
    @Shadow
    private int margin;
    private Point imblocker$caretPos = Point.TOP_LEFT;

    @Shadow
    public abstract String getCurrentLine();

    @Shadow
    public abstract int getCursorX();

    @Shadow
    public abstract int getRenderSafeCursorY();

    @Override
    public void focusChanged(boolean isFocused, CallbackInfo ci) {
        this.imblocker$onFocusChanged(isFocused);
    }

    @Inject(method={"charTyped", "m_5534_"}, at={@At(value="HEAD")}, cancellable=true)
    public void checkFocusTracking(char chr, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (FocusManager.isTrackingFocus) {
            if (this.isFocused()) {
                FocusContainer.MINECRAFT.switchFocus(this);
                cir.setReturnValue((Object)true);
            } else {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"renderCursor"}, at={@At(value="TAIL")})
    public void updateCaretPos(CallbackInfo ci) {
        int caretX = this.margin + MinecraftClientAccessor.INSTANCE.getStringWidth(StringUtil.getSubstring(this.getCurrentLine(), 0, this.getCursorX()));
        int caretY = this.margin + this.getRenderSafeCursorY() * 9;
        Point currentCaretPos = new Point(this.getGuiScale(), caretX, caretY);
        if (!this.imblocker$caretPos.equals(currentCaretPos)) {
            this.imblocker$caretPos = currentCaretPos;
            IMManager.updateCompositionWindowPos();
        }
    }

    @Override
    public Point getCaretPos() {
        return this.imblocker$caretPos;
    }
}

