/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.mixin.compat;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.ScrollingContainer;
import com.ldtteam.blockui.views.View;
import io.github.reserveword.imblocker.common.MathHelper;
import io.github.reserveword.imblocker.common.gui.MinecraftFocusableWidget;
import io.github.reserveword.imblocker.common.gui.Rectangle;
import io.github.reserveword.imblocker.mixin.compat.BlockUIBOScreenAccessor;
import io.github.reserveword.imblocker.mixin.compat.BlockUIViewAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Pane.class}, remap=false)
public abstract class BlockUIPaneMixin
implements MinecraftFocusableWidget {
    @Shadow
    protected View parent;
    @Shadow
    protected BOWindow window;
    @Shadow
    protected int x;
    @Shadow
    protected int y;
    @Shadow
    protected int width;
    @Shadow
    protected int height;

    @Inject(method={"onFocusLost"}, at={@At(value="TAIL")})
    public void focusLost(CallbackInfo ci) {
    }

    @Override
    public Rectangle getBoundsAbs() {
        int xAbs = this.x;
        int yAbs = this.y;
        View parent = this.parent;
        while (parent != null) {
            if (ScrollingContainer.class.isInstance(parent)) {
                yAbs = (int)((double)yAbs - ((ScrollingContainer)parent).getScrollY());
                yAbs = MathHelper.clamp(yAbs, 0, parent.getHeight() - 4);
            }
            xAbs += parent.getX() + ((BlockUIViewAccessor)parent).getPadding();
            yAbs += parent.getY() + ((BlockUIViewAccessor)parent).getPadding();
            parent = ((BlockUIPaneMixin)parent).parent;
        }
        double renderScale = this.window.getScreen().getRenderScale();
        xAbs = (int)((double)xAbs * renderScale + ((BlockUIBOScreenAccessor)this.window.getScreen()).getX());
        yAbs = (int)((double)yAbs * renderScale + ((BlockUIBOScreenAccessor)this.window.getScreen()).getY());
        return new Rectangle(xAbs, yAbs, (int)((double)this.width * renderScale), (int)((double)this.height * renderScale));
    }

    @Override
    public double getGuiScale() {
        return this.window.getScreen().getRenderScale();
    }
}

