/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.deadlyweapons.entity;

import net.mcreator.deadlyweapons.init.DeadlyWeaponsModEntities;
import net.mcreator.deadlyweapons.procedures.GoblinCanAttackProcedure;
import net.mcreator.deadlyweapons.procedures.GoblinCanRunProcedure;
import net.mcreator.deadlyweapons.procedures.LootGoblinNaturalEntitySpawningConditionProcedure;
import net.mcreator.deadlyweapons.procedures.LootGoblinOnEntityTickUpdateProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class LootGoblinEntity
extends Monster {
    public final AnimationState animationState1 = new AnimationState();

    public LootGoblinEntity(EntityType<LootGoblinEntity> type, Level world) {
        super(type, world);
        this.xpReward = 32;
        this.setNoAi(false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.2));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false){

            public boolean canUse() {
                double x = LootGoblinEntity.this.getX();
                double y = LootGoblinEntity.this.getY();
                double z = LootGoblinEntity.this.getZ();
                LootGoblinEntity entity = LootGoblinEntity.this;
                Level world = LootGoblinEntity.this.level();
                return super.canUse() && GoblinCanAttackProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = LootGoblinEntity.this.getX();
                double y = LootGoblinEntity.this.getY();
                double z = LootGoblinEntity.this.getZ();
                LootGoblinEntity entity = LootGoblinEntity.this;
                Level world = LootGoblinEntity.this.level();
                return super.canContinueToUse() && GoblinCanAttackProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 4.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = LootGoblinEntity.this.getX();
                double y = LootGoblinEntity.this.getY();
                double z = LootGoblinEntity.this.getZ();
                LootGoblinEntity entity = LootGoblinEntity.this;
                Level world = LootGoblinEntity.this.level();
                return super.canUse() && GoblinCanAttackProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = LootGoblinEntity.this.getX();
                double y = LootGoblinEntity.this.getY();
                double z = LootGoblinEntity.this.getZ();
                LootGoblinEntity entity = LootGoblinEntity.this;
                Level world = LootGoblinEntity.this.level();
                return super.canContinueToUse() && GoblinCanAttackProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal<Player>((PathfinderMob)this, Player.class, 48.0f, 1.6, 1.6){

            public boolean canUse() {
                double x = LootGoblinEntity.this.getX();
                double y = LootGoblinEntity.this.getY();
                double z = LootGoblinEntity.this.getZ();
                LootGoblinEntity entity = LootGoblinEntity.this;
                Level world = LootGoblinEntity.this.level();
                return super.canUse() && GoblinCanRunProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = LootGoblinEntity.this.getX();
                double y = LootGoblinEntity.this.getY();
                double z = LootGoblinEntity.this.getZ();
                LootGoblinEntity entity = LootGoblinEntity.this;
                Level world = LootGoblinEntity.this.level();
                return super.canContinueToUse() && GoblinCanRunProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new FloatGoal((Mob)this));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"deadly_weapons:entity.loot_goblin.idle"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"deadly_weapons:entity.loot_goblin.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"deadly_weapons:entity.loot_goblin.death"));
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState1.animateWhen(true, this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        LootGoblinOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)DeadlyWeaponsModEntities.LOOT_GOBLIN.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return LootGoblinNaturalEntitySpawningConditionProcedure.execute((LevelAccessor)world);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.4);
        builder = builder.add(Attributes.MAX_HEALTH, 60.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 5.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 64.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

