/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.deadlyweapons.network;

import java.util.HashMap;
import net.mcreator.deadlyweapons.DeadlyWeaponsMod;
import net.mcreator.deadlyweapons.procedures.BlazeScreamerMsgProcedure;
import net.mcreator.deadlyweapons.procedures.BlockerMsgProcedure;
import net.mcreator.deadlyweapons.procedures.BomberMsgProcedure;
import net.mcreator.deadlyweapons.procedures.DeathsFuryMsgProcedure;
import net.mcreator.deadlyweapons.procedures.DexterityMsgProcedure;
import net.mcreator.deadlyweapons.procedures.GreedMsgProcedure;
import net.mcreator.deadlyweapons.procedures.HeavyBlowMsgProcedure;
import net.mcreator.deadlyweapons.procedures.HeavyFootMsgProcedure;
import net.mcreator.deadlyweapons.procedures.IronWillMsgProcedure;
import net.mcreator.deadlyweapons.procedures.LootGoblinTradeProcedure;
import net.mcreator.deadlyweapons.procedures.MaskedMsgProcedure;
import net.mcreator.deadlyweapons.procedures.RampageMsgProcedure;
import net.mcreator.deadlyweapons.procedures.RampantRollMsgProcedure;
import net.mcreator.deadlyweapons.procedures.SatiatedMsgProcedure;
import net.mcreator.deadlyweapons.procedures.ShadowSeeperMsgProcedure;
import net.mcreator.deadlyweapons.procedures.WarpingMsgProcedure;
import net.mcreator.deadlyweapons.world.inventory.LootGoblinTradesMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record LootGoblinTradesButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<LootGoblinTradesButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"deadly_weapons", (String)"loot_goblin_trades_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, LootGoblinTradesButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new LootGoblinTradesButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<LootGoblinTradesButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(LootGoblinTradesButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                LootGoblinTradesButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = LootGoblinTradesMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            RampageMsgProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            GreedMsgProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            IronWillMsgProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            WarpingMsgProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            HeavyFootMsgProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            SatiatedMsgProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            LootGoblinTradeProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            ShadowSeeperMsgProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            BomberMsgProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            HeavyBlowMsgProcedure.execute((Entity)entity);
        }
        if (buttonID == 10) {
            BlazeScreamerMsgProcedure.execute((Entity)entity);
        }
        if (buttonID == 11) {
            DexterityMsgProcedure.execute((Entity)entity);
        }
        if (buttonID == 12) {
            DeathsFuryMsgProcedure.execute((Entity)entity);
        }
        if (buttonID == 13) {
            BlockerMsgProcedure.execute((Entity)entity);
        }
        if (buttonID == 14) {
            RampantRollMsgProcedure.execute((Entity)entity);
        }
        if (buttonID == 15) {
            MaskedMsgProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        DeadlyWeaponsMod.addNetworkMessage(TYPE, STREAM_CODEC, LootGoblinTradesButtonMessage::handleData);
    }
}

