/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.deadlyweapons.procedures;

import java.util.Comparator;
import javax.annotation.Nullable;
import net.mcreator.deadlyweapons.DeadlyWeaponsMod;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(value={Dist.CLIENT})
public class BlazeScreamerScreamProcedure {
    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickEmpty event) {
        if (event.getHand() != event.getEntity().getUsedItemHand()) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new BlazeScreamerScreamMessage(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        BlazeScreamerScreamProcedure.execute((LevelAccessor)event.getLevel(), event.getPos().getX(), event.getPos().getY(), event.getPos().getZ(), (Entity)event.getEntity());
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        BlazeScreamerScreamProcedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity.getPersistentData().getString("Slot1").equals("BlazeScreamer") && entity.getPersistentData().getString("Slot3").equals("BlazeScreamer") && entity.getPersistentData().getString("Slot2").equals("BlazeScreamer") && (!entity.isShiftKeyDown() || !entity.isSprinting()) && entity.getPersistentData().getDouble("BlazeScreamerScreamCooldown") <= 0.0) {
            LivingEntity _entity;
            Level _level;
            if (world instanceof Level) {
                _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.sculk_shrieker.shriek")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                } else {
                    _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.sculk_shrieker.shriek")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                }
            }
            if (world instanceof Level) {
                _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"item.firecharge.use")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                } else {
                    _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"item.firecharge.use")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                }
            }
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)ParticleTypes.FLAME, x, y, z, 128, 0.0, 0.0, 0.0, 0.15);
            }
            if (entity instanceof LivingEntity && !(_entity = (LivingEntity)entity).level().isClientSide()) {
                _entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 220, 1, true, true));
            }
            Vec3 _center = new Vec3(x, y, z);
            for (Entity entityiterator : world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(3.5), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList()) {
                ServerLevel _level2;
                if (entityiterator == entity) continue;
                entityiterator.igniteForSeconds(10.0f);
                entityiterator.hurt(new DamageSource(world.holderOrThrow(DamageTypes.ON_FIRE), entity), 12.0f);
                if (world instanceof ServerLevel) {
                    _level2 = (ServerLevel)world;
                    _level2.sendParticles((ParticleOptions)ParticleTypes.LAVA, entityiterator.getX(), entityiterator.getY(), entityiterator.getZ(), 4, 0.0, 0.0, 0.0, 0.0);
                }
                if (world instanceof Level) {
                    _level2 = (Level)world;
                    if (!_level2.isClientSide()) {
                        _level2.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"item.firecharge.use")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    } else {
                        _level2.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"item.firecharge.use")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                    }
                }
                if (!(world instanceof Level)) continue;
                _level2 = (Level)world;
                if (!_level2.isClientSide()) {
                    _level2.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.explode")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    continue;
                }
                _level2.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.explode")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            }
            entity.getPersistentData().putDouble("BlazeScreamerScreamLogic", 1.0);
            entity.getPersistentData().putDouble("BlazeScreamerScreamCooldown", 240.0);
        }
    }

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
    public record BlazeScreamerScreamMessage() implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<BlazeScreamerScreamMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"deadly_weapons", (String)"procedure_blaze_screamer_scream"));
        public static final StreamCodec<RegistryFriendlyByteBuf, BlazeScreamerScreamMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {}, buffer -> new BlazeScreamerScreamMessage());

        public CustomPacketPayload.Type<BlazeScreamerScreamMessage> type() {
            return TYPE;
        }

        public static void handleData(BlazeScreamerScreamMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.SERVERBOUND) {
                context.enqueueWork(() -> {
                    if (!context.player().level().hasChunkAt(context.player().blockPosition())) {
                        return;
                    }
                    BlazeScreamerScreamProcedure.execute((LevelAccessor)context.player().level(), context.player().getX(), context.player().getY(), context.player().getZ(), (Entity)context.player());
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }

        @SubscribeEvent
        public static void registerMessage(FMLCommonSetupEvent event) {
            DeadlyWeaponsMod.addNetworkMessage(TYPE, STREAM_CODEC, BlazeScreamerScreamMessage::handleData);
        }
    }
}

