/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.deadlyweapons.procedures;

import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;

@EventBusSubscriber
public class HeavyFootFallProcedure {
    @SubscribeEvent
    public static void onEntityFall(LivingFallEvent event) {
        if (event.getEntity() != null) {
            HeavyFootFallProcedure.execute((Event)event, (LevelAccessor)event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), (Entity)event.getEntity());
        }
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        HeavyFootFallProcedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        if ((entity.getPersistentData().getString("Slot1").equals("HeavyFoot") || entity.getPersistentData().getString("Slot2").equals("HeavyFoot") || entity.getPersistentData().getString("Slot3").equals("HeavyFoot")) && !entity.isShiftKeyDown() && !entity.isSprinting()) {
            Level _level;
            if (world instanceof Level) {
                _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.iron_golem.damage")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                } else {
                    _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.iron_golem.damage")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                }
            }
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)ParticleTypes.CLOUD, x, y, z, 16, 0.5, 0.0, 0.5, 0.1);
            }
            Vec3 _center = new Vec3(x, y, z);
            for (Entity entityiterator : world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(2.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList()) {
                ServerLevel _level2;
                if (entityiterator == entity) continue;
                entityiterator.hurt(new DamageSource(world.holderOrThrow(ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)"deadly_weapons:trample"))), entity), (float)(8.0 * entity.getPersistentData().getDouble("SlamCount")));
                if (world instanceof ServerLevel) {
                    _level2 = (ServerLevel)world;
                    _level2.sendParticles((ParticleOptions)ParticleTypes.CLOUD, entityiterator.getX(), entityiterator.getY() + 0.5, entityiterator.getZ(), 4, 0.0, 0.0, 0.0, 0.1);
                }
                if (world instanceof Level) {
                    _level2 = (Level)world;
                    if (!_level2.isClientSide()) {
                        _level2.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.anvil.place")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    } else {
                        _level2.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.anvil.place")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                    }
                }
                entity.hurt(new DamageSource(world.holderOrThrow(DamageTypes.FALL)), 1.0f);
            }
        }
    }
}

