/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.deadlyweapons.procedures;

import java.util.Comparator;
import javax.annotation.Nullable;
import net.mcreator.deadlyweapons.init.DeadlyWeaponsModMobEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;

@EventBusSubscriber
public class SlammedFallProcedure {
    @SubscribeEvent
    public static void onEntityFall(LivingFallEvent event) {
        if (event.getEntity() != null) {
            SlammedFallProcedure.execute((Event)event, (LevelAccessor)event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), (Entity)event.getEntity());
        }
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        SlammedFallProcedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        if (entity.getPersistentData().getDouble("Slammed") == 1.0) {
            ServerLevel _level;
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                LightningBolt entityToSpawn = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)_level);
                entityToSpawn.moveTo(Vec3.atBottomCenterOf((Vec3i)BlockPos.containing((double)x, (double)y, (double)z)));
                entityToSpawn.setVisualOnly(true);
                _level.addFreshEntity((Entity)entityToSpawn);
            }
            if (world instanceof Level && !(_level = (Level)world).isClientSide()) {
                _level.explode(null, x, y, z, 4.0f, Level.ExplosionInteraction.MOB);
            }
            if (world instanceof Level) {
                _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.explode")), SoundSource.NEUTRAL, 5.0f, 1.0f);
                } else {
                    _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.explode")), SoundSource.NEUTRAL, 5.0f, 1.0f, false);
                }
            }
            if (world instanceof Level) {
                _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.explode")), SoundSource.NEUTRAL, 5.0f, 0.6f);
                } else {
                    _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.explode")), SoundSource.NEUTRAL, 5.0f, 0.6f, false);
                }
            }
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)ParticleTypes.CLOUD, x, y, z, 128, 1.0, 1.0, 1.0, 0.5);
            }
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, x, y, z, 128, 1.0, 1.0, 1.0, 0.5);
            }
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, x, y, z, 1, 1.0, 1.0, 1.0, 0.5);
            }
            entity.hurt(new DamageSource(world.holderOrThrow(DamageTypes.EXPLOSION)), 12.0f);
            Vec3 _center = new Vec3(x, y, z);
            for (Entity entityiterator : world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(10.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList()) {
                LivingEntity _entity;
                if (!(entityiterator instanceof LivingEntity) || (_entity = (LivingEntity)entityiterator).level().isClientSide()) continue;
                _entity.addEffect(new MobEffectInstance(DeadlyWeaponsModMobEffects.SHAKE, 20, 1, false, true));
            }
            entity.getPersistentData().putDouble("Slammed", 0.0);
        }
    }
}

