/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.deadlyweapons.init;

import net.mcreator.deadlyweapons.potion.BlisseffectMobEffect;
import net.mcreator.deadlyweapons.potion.ChainedMobEffect;
import net.mcreator.deadlyweapons.potion.CursedMobEffect;
import net.mcreator.deadlyweapons.potion.ExtremePoisonMobEffect;
import net.mcreator.deadlyweapons.potion.FloatingMobEffect;
import net.mcreator.deadlyweapons.potion.FrozenMobEffect;
import net.mcreator.deadlyweapons.potion.GhostMobEffect;
import net.mcreator.deadlyweapons.potion.RingingMobEffect;
import net.mcreator.deadlyweapons.potion.ShulkerShellMobEffect;
import net.mcreator.deadlyweapons.potion.SilverbangMobEffect;
import net.mcreator.deadlyweapons.potion.WebbedMobEffect;
import net.mcreator.deadlyweapons.procedures.BlisseffectEffectExpiresProcedure;
import net.mcreator.deadlyweapons.procedures.ChainedEffectStartedappliedProcedure;
import net.mcreator.deadlyweapons.procedures.RingingEffectExpiresProcedure;
import net.mcreator.deadlyweapons.procedures.SilverbangEffectExpiresProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class DeadlyWeaponsModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"deadly_weapons");
    public static final DeferredHolder<MobEffect, MobEffect> BLISSEFFECT = REGISTRY.register("blisseffect", () -> new BlisseffectMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> CHAINED = REGISTRY.register("chained", () -> new ChainedMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> RINGING = REGISTRY.register("ringing", () -> new RingingMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> GHOST = REGISTRY.register("ghost", () -> new GhostMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> EXTREME_POISON = REGISTRY.register("extreme_poison", () -> new ExtremePoisonMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> FROZEN = REGISTRY.register("frozen", () -> new FrozenMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SHULKER_SHELL = REGISTRY.register("shulker_shell", () -> new ShulkerShellMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> CURSED = REGISTRY.register("cursed", () -> new CursedMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SILVERBANG = REGISTRY.register("silverbang", () -> new SilverbangMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> WEBBED = REGISTRY.register("webbed", () -> new WebbedMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> FLOATING = REGISTRY.register("floating", () -> new FloatingMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            DeadlyWeaponsModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            DeadlyWeaponsModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(BLISSEFFECT)) {
            BlisseffectEffectExpiresProcedure.execute(entity);
        } else if (effectInstance.getEffect().is(CHAINED)) {
            ChainedEffectStartedappliedProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ());
        } else if (effectInstance.getEffect().is(RINGING)) {
            RingingEffectExpiresProcedure.execute(entity);
        } else if (effectInstance.getEffect().is(SILVERBANG)) {
            SilverbangEffectExpiresProcedure.execute(entity);
        }
    }
}

