/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.deadlyweapons.network;

import java.util.HashMap;
import net.mcreator.deadlyweapons.DeadlyWeaponsMod;
import net.mcreator.deadlyweapons.procedures.ItemTakenProcedure;
import net.mcreator.deadlyweapons.procedures.Slot1TakeProcedure;
import net.mcreator.deadlyweapons.world.inventory.LootGoblinTradesMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record LootGoblinTradesSlotMessage(int slotID, int x, int y, int z, int changeType, int meta) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<LootGoblinTradesSlotMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"deadly_weapons", (String)"loot_goblin_trades_slots"));
    public static final StreamCodec<RegistryFriendlyByteBuf, LootGoblinTradesSlotMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.slotID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.writeInt(message.changeType);
        buffer.writeInt(message.meta);
    }, buffer -> new LootGoblinTradesSlotMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<LootGoblinTradesSlotMessage> type() {
        return TYPE;
    }

    public static void handleData(LootGoblinTradesSlotMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int slotID = message.slotID;
                int changeType = message.changeType;
                int meta = message.meta;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                LootGoblinTradesSlotMessage.handleSlotAction(entity, slotID, changeType, meta, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleSlotAction(Player entity, int slot, int changeType, int meta, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = LootGoblinTradesMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (slot == 0 && changeType == 1) {
            Slot1TakeProcedure.execute((Entity)entity);
        }
        if (slot == 1 && changeType == 1) {
            Slot1TakeProcedure.execute((Entity)entity);
        }
        if (slot == 2 && changeType == 1) {
            ItemTakenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        DeadlyWeaponsMod.addNetworkMessage(TYPE, STREAM_CODEC, LootGoblinTradesSlotMessage::handleData);
    }
}

