/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.deadlyweapons.procedures;

import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class RadiantRageProcedure {
    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        RadiantRageProcedure.execute((Event)event, (LevelAccessor)event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), (Entity)event.getEntity());
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        RadiantRageProcedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity) {
        Vec3 _center;
        if (entity == null) {
            return;
        }
        if (entity.getPersistentData().getDouble("RadiantRage") == 1.0) {
            ServerLevel _level;
            if (entity instanceof LivingEntity) {
                LivingEntity _entity = (LivingEntity)entity;
                _entity.swing(InteractionHand.MAIN_HAND, true);
            }
            entity.getPersistentData().putDouble("RadiantStrike", entity.getPersistentData().getDouble("RadiantStrike") + 1.0);
            entity.getPersistentData().putDouble("RadiantRageCount", entity.getPersistentData().getDouble("RadiantRageCount") + 1.0);
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)ParticleTypes.SWEEP_ATTACK, x, y + 0.5, z, 2, 0.8, 0.0, 0.8, 0.0);
            }
            if (world instanceof Level) {
                _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.player.attack.sweep")), SoundSource.NEUTRAL, 1.0f, (float)Mth.nextDouble((RandomSource)RandomSource.create(), (double)0.8, (double)1.2));
                } else {
                    _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.player.attack.sweep")), SoundSource.NEUTRAL, 1.0f, (float)Mth.nextDouble((RandomSource)RandomSource.create(), (double)0.8, (double)1.2), false);
                }
            }
            _center = new Vec3(x, y, z);
            for (Entity entityiterator : world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(2.5), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList()) {
                if (entityiterator == entity || !(entityiterator instanceof LivingEntity)) continue;
                entityiterator.hurt(new DamageSource(world.holderOrThrow(DamageTypes.PLAYER_ATTACK), entity), 6.0f);
            }
        }
        if (entity.getPersistentData().getDouble("RadiantStrike") == 10.0) {
            entity.getPersistentData().putDouble("RadiantStrike", 0.0);
            _center = new Vec3(x, y, z);
            for (Entity entityiterator : world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(2.5), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList()) {
                if (entityiterator == entity || !(entityiterator instanceof LivingEntity)) continue;
                entityiterator.hurt(new DamageSource(world.holderOrThrow(DamageTypes.LIGHTNING_BOLT), entity), 12.0f);
                if (!(world instanceof ServerLevel)) continue;
                ServerLevel _level = (ServerLevel)world;
                LightningBolt entityToSpawn = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)_level);
                entityToSpawn.moveTo(Vec3.atBottomCenterOf((Vec3i)BlockPos.containing((double)entityiterator.getX(), (double)entityiterator.getY(), (double)entityiterator.getZ())));
                entityToSpawn.setVisualOnly(true);
                _level.addFreshEntity((Entity)entityToSpawn);
            }
        }
        if (entity.getPersistentData().getDouble("RadiantRageCount") >= 30.0) {
            entity.getPersistentData().putDouble("RadiantStrike", 0.0);
            entity.getPersistentData().putDouble("RadiantRage", 0.0);
            entity.getPersistentData().putDouble("RadiantRageCount", 0.0);
        }
    }
}

