/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.deadlyweapons.init;

import net.mcreator.deadlyweapons.potion.AcryllickedMobEffect;
import net.mcreator.deadlyweapons.potion.BlisseffectMobEffect;
import net.mcreator.deadlyweapons.potion.BouncyMobEffect;
import net.mcreator.deadlyweapons.potion.ChainedMobEffect;
import net.mcreator.deadlyweapons.potion.CursedMobEffect;
import net.mcreator.deadlyweapons.potion.DeathsFuryMobEffect;
import net.mcreator.deadlyweapons.potion.DeathsFurySecondaryMobEffect;
import net.mcreator.deadlyweapons.potion.DeathsFuryTertiaryMobEffect;
import net.mcreator.deadlyweapons.potion.DelightfulPerfumeMobEffect;
import net.mcreator.deadlyweapons.potion.DexterityEffectMobEffect;
import net.mcreator.deadlyweapons.potion.ExtremePoisonMobEffect;
import net.mcreator.deadlyweapons.potion.FloatingMobEffect;
import net.mcreator.deadlyweapons.potion.FrozenMobEffect;
import net.mcreator.deadlyweapons.potion.GhostMobEffect;
import net.mcreator.deadlyweapons.potion.IronWillEffectMobEffect;
import net.mcreator.deadlyweapons.potion.MaceStillMobEffect;
import net.mcreator.deadlyweapons.potion.RampagingEffectMobEffect;
import net.mcreator.deadlyweapons.potion.RampagingSecondaryMobEffect;
import net.mcreator.deadlyweapons.potion.RampagingTertiaryMobEffect;
import net.mcreator.deadlyweapons.potion.RampantRollEffectMobEffect;
import net.mcreator.deadlyweapons.potion.RampantRollSecondaryMobEffect;
import net.mcreator.deadlyweapons.potion.RampantRollTertiaryMobEffect;
import net.mcreator.deadlyweapons.potion.RingingMobEffect;
import net.mcreator.deadlyweapons.potion.SecondaryDexterityMobEffect;
import net.mcreator.deadlyweapons.potion.SecondaryIronWillMobEffect;
import net.mcreator.deadlyweapons.potion.ShulkerShellMobEffect;
import net.mcreator.deadlyweapons.potion.SilverbangMobEffect;
import net.mcreator.deadlyweapons.potion.StilledMobEffect;
import net.mcreator.deadlyweapons.potion.TertiaryDexterityMobEffect;
import net.mcreator.deadlyweapons.potion.TertiaryIronWillMobEffect;
import net.mcreator.deadlyweapons.potion.WebbedMobEffect;
import net.mcreator.deadlyweapons.procedures.AcryllickedEffectExpiresProcedure;
import net.mcreator.deadlyweapons.procedures.BlisseffectEffectExpiresProcedure;
import net.mcreator.deadlyweapons.procedures.ChainedEffectStartedappliedProcedure;
import net.mcreator.deadlyweapons.procedures.DelightfulPerfumeEffectExpiresProcedure;
import net.mcreator.deadlyweapons.procedures.RingingEffectExpiresProcedure;
import net.mcreator.deadlyweapons.procedures.SilverbangEffectExpiresProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class DeadlyWeaponsModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"deadly_weapons");
    public static final DeferredHolder<MobEffect, MobEffect> BLISSEFFECT = REGISTRY.register("blisseffect", () -> new BlisseffectMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> CHAINED = REGISTRY.register("chained", () -> new ChainedMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> RINGING = REGISTRY.register("ringing", () -> new RingingMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> GHOST = REGISTRY.register("ghost", () -> new GhostMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> EXTREME_POISON = REGISTRY.register("extreme_poison", () -> new ExtremePoisonMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> FROZEN = REGISTRY.register("frozen", () -> new FrozenMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SHULKER_SHELL = REGISTRY.register("shulker_shell", () -> new ShulkerShellMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> CURSED = REGISTRY.register("cursed", () -> new CursedMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SILVERBANG = REGISTRY.register("silverbang", () -> new SilverbangMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> WEBBED = REGISTRY.register("webbed", () -> new WebbedMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> FLOATING = REGISTRY.register("floating", () -> new FloatingMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> STILLED = REGISTRY.register("stilled", () -> new StilledMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> BOUNCY = REGISTRY.register("bouncy", () -> new BouncyMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> MACE_STILL = REGISTRY.register("mace_still", () -> new MaceStillMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> RAMPAGING_EFFECT = REGISTRY.register("rampaging_effect", () -> new RampagingEffectMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> RAMPAGING_SECONDARY = REGISTRY.register("rampaging_secondary", () -> new RampagingSecondaryMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> RAMPAGING_TERTIARY = REGISTRY.register("rampaging_tertiary", () -> new RampagingTertiaryMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> IRON_WILL_EFFECT = REGISTRY.register("iron_will_effect", () -> new IronWillEffectMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SECONDARY_IRON_WILL = REGISTRY.register("secondary_iron_will", () -> new SecondaryIronWillMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> TERTIARY_IRON_WILL = REGISTRY.register("tertiary_iron_will", () -> new TertiaryIronWillMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> DELIGHTFUL_PERFUME = REGISTRY.register("delightful_perfume", () -> new DelightfulPerfumeMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ACRYLLICKED = REGISTRY.register("acryllicked", () -> new AcryllickedMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> DEXTERITY_EFFECT = REGISTRY.register("dexterity_effect", () -> new DexterityEffectMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> SECONDARY_DEXTERITY = REGISTRY.register("secondary_dexterity", () -> new SecondaryDexterityMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> TERTIARY_DEXTERITY = REGISTRY.register("tertiary_dexterity", () -> new TertiaryDexterityMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> DEATHS_FURY = REGISTRY.register("deaths_fury", () -> new DeathsFuryMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> DEATHS_FURY_SECONDARY = REGISTRY.register("deaths_fury_secondary", () -> new DeathsFurySecondaryMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> DEATHS_FURY_TERTIARY = REGISTRY.register("deaths_fury_tertiary", () -> new DeathsFuryTertiaryMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> RAMPANT_ROLL_EFFECT = REGISTRY.register("rampant_roll_effect", () -> new RampantRollEffectMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> RAMPANT_ROLL_SECONDARY = REGISTRY.register("rampant_roll_secondary", () -> new RampantRollSecondaryMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> RAMPANT_ROLL_TERTIARY = REGISTRY.register("rampant_roll_tertiary", () -> new RampantRollTertiaryMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            DeadlyWeaponsModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            DeadlyWeaponsModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(BLISSEFFECT)) {
            BlisseffectEffectExpiresProcedure.execute(entity);
        } else if (effectInstance.getEffect().is(CHAINED)) {
            ChainedEffectStartedappliedProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ());
        } else if (effectInstance.getEffect().is(RINGING)) {
            RingingEffectExpiresProcedure.execute(entity);
        } else if (effectInstance.getEffect().is(SILVERBANG)) {
            SilverbangEffectExpiresProcedure.execute(entity);
        } else if (effectInstance.getEffect().is(DELIGHTFUL_PERFUME)) {
            DelightfulPerfumeEffectExpiresProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ(), entity);
        } else if (effectInstance.getEffect().is(ACRYLLICKED)) {
            AcryllickedEffectExpiresProcedure.execute(entity);
        }
    }
}

