/*
 * Decompiled with CFR 0.152.
 */
package net.unknown_raccoon.allium_plus.entity;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import net.unknown_raccoon.allium_plus.init.AlliumPlusModEntities;
import net.unknown_raccoon.allium_plus.procedures.GradusOrRimeEntityDiesProcedure;
import net.unknown_raccoon.allium_plus.procedures.OverworldEntitySpawningConditionProcedure;
import net.unknown_raccoon.allium_plus.procedures.RimeEntityIsHurtProcedure;
import net.unknown_raccoon.allium_plus.procedures.RimeOnEntityTickUpdateProcedure;

public class RimeEntity
extends Monster {
    public RimeEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<RimeEntity>)((EntityType)AlliumPlusModEntities.RIME.get()), world);
    }

    public RimeEntity(EntityType<RimeEntity> type, Level world) {
        super(type, world);
        this.m_274367_(5.0f);
        this.f_21364_ = 28;
        this.m_21557_(false);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new FloatGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.enderman.ambient"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.enderman.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.enderman.death"));
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        Level world = this.m_9236_();
        RimeEntity entity = this;
        Entity sourceentity = damagesource.m_7639_();
        Entity immediatesourceentity = damagesource.m_7640_();
        RimeEntityIsHurtProcedure.execute((LevelAccessor)world, damagesource, (Entity)entity);
        return super.m_6469_(damagesource, amount);
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        GradusOrRimeEntityDiesProcedure.execute(source.m_7639_());
    }

    public void m_6075_() {
        super.m_6075_();
        RimeOnEntityTickUpdateProcedure.execute((LevelAccessor)this.m_9236_(), (Entity)this);
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)AlliumPlusModEntities.RIME.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            return OverworldEntitySpawningConditionProcedure.execute((LevelAccessor)world);
        });
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.4);
        builder = builder.m_22268_(Attributes.f_22276_, 280.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 8.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }
}

