/*
 * Decompiled with CFR 0.152.
 */
package net.vercte.extendedwrenches;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.tterrag.registrate.providers.ProviderType;
import io.github.fabricators_of_create.porting_lib.data.ExistingFileHelper;
import java.util.Map;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7877;
import net.vercte.extendedwrenches.ExtendedWrenches;
import net.vercte.extendedwrenches.datagen.ExtendedEntriesProvider;
import net.vercte.extendedwrenches.datagen.ExtendedWrenchSwapRecipeProvider;
import net.vercte.extendedwrenches.wrench.WrenchMaterial;

public class ExtendedWrenchesData
implements DataGeneratorEntrypoint {
    public static final class_5321<class_2378<WrenchMaterial>> WRENCH_MATERIAL = ExtendedWrenchesData.key("wrench_material");

    private static <T> class_5321<class_2378<T>> key(String name) {
        return class_5321.method_29180((class_2960)ExtendedWrenches.asResource(name));
    }

    public static void registerDatapackRegistries() {
        DynamicRegistries.registerSynced(WRENCH_MATERIAL, WrenchMaterial.CODEC, (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
    }

    public void buildRegistry(class_7877 builder) {
        ExtendedEntriesProvider.addBootstraps(builder);
    }

    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        ExistingFileHelper helper = ExistingFileHelper.withResourcesFromArg();
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        ExtendedWrenches.REGISTRATE.setupDatagen(pack, helper);
        ExtendedWrenchesData.gatherData(pack);
    }

    public static void gatherData(FabricDataGenerator.Pack pack) {
        ExtendedWrenches.REGISTRATE.addDataGenerator(ProviderType.LANG, lang -> {
            String interfacePath = "assets/extendedwrenches/lang/default/interface.json";
            JsonElement jsonElement = FilesHelper.loadJsonResource((String)interfacePath);
            if (jsonElement == null) {
                throw new IllegalStateException(String.format("Could not find interface lang file: %s", interfacePath));
            }
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                String key = (String)entry.getKey();
                String value = ((JsonElement)entry.getValue()).getAsString();
                lang.add(key, value);
            }
        });
        pack.addProvider(ExtendedEntriesProvider::new);
        pack.addProvider(ExtendedWrenchSwapRecipeProvider::new);
    }
}

