/*
 * Decompiled with CFR 0.152.
 */
package net.vercte.extendedwrenches.compat;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.every_compat.misc.HardcodedBlockType;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.Respriter;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7923;
import net.vercte.extendedwrenches.ExtendedItems;
import net.vercte.extendedwrenches.ExtendedWrenches;

public class WoodGood
extends SimpleModule {
    public WoodGood(String modId) {
        super(modId, "cew", "everycomp");
    }

    public void addDynamicClientResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicClientResources(executor);
        executor.accept((manager, sink) -> {
            for (WoodType woodType : WoodTypeRegistry.INSTANCE) {
                if (HardcodedBlockType.isKnownVanillaWood((WoodType)woodType)) continue;
                try {
                    TextureImage cogTexture = TextureImage.open((class_3300)manager, (class_2960)ExtendedWrenches.asResource("item/extended_wrench/cog_materials/oak"));
                    try {
                        TextureImage handleTexture = TextureImage.open((class_3300)manager, (class_2960)ExtendedWrenches.asResource("item/extended_wrench/handle_materials/oak"));
                        try {
                            TextureImage plankTexture = TextureImage.open((class_3300)manager, (class_2960)RPUtils.findFirstBlockTextureLocation((class_3300)manager, (class_2248)woodType.planks));
                            try {
                                Respriter cogRespriter = Respriter.of((TextureImage)cogTexture);
                                Respriter handleRespriter = Respriter.of((TextureImage)handleTexture);
                                List plankPalette = Palette.fromAnimatedImage((TextureImage)plankTexture);
                                McMetaFile plankMeta = plankTexture.getMcMeta();
                                try {
                                    TextureImage cogRecolored = cogRespriter.recolorWithAnimation(plankPalette, plankMeta);
                                    try {
                                        TextureImage handleRecolored = handleRespriter.recolorWithAnimation(plankPalette, plankMeta);
                                        try {
                                            sink.addTexture(this.getCogTexturePath(woodType), cogRecolored);
                                            sink.addTexture(this.getHandleTexturePath(woodType), handleRecolored);
                                        }
                                        finally {
                                            if (handleRecolored == null) continue;
                                            handleRecolored.close();
                                        }
                                    }
                                    finally {
                                        if (cogRecolored == null) continue;
                                        cogRecolored.close();
                                    }
                                }
                                catch (Exception e) {
                                    ExtendedWrenches.LOGGER.error("Error generating texture", (Throwable)e);
                                }
                            }
                            finally {
                                if (plankTexture == null) continue;
                                plankTexture.close();
                            }
                        }
                        finally {
                            if (handleTexture == null) continue;
                            handleTexture.close();
                        }
                    }
                    finally {
                        if (cogTexture == null) continue;
                        cogTexture.close();
                    }
                }
                catch (Exception e) {
                    ExtendedWrenches.LOGGER.error("Error generating texture", (Throwable)e);
                }
            }
        });
    }

    public void addDynamicServerResources(Consumer<ResourceGenTask> executor) {
        super.addDynamicServerResources(executor);
        executor.accept((manager, sink) -> {
            for (WoodType woodType : WoodTypeRegistry.INSTANCE) {
                if (HardcodedBlockType.isKnownVanillaWood((WoodType)woodType)) continue;
                JsonObject cogMaterial = new JsonObject();
                cogMaterial.add("part", (JsonElement)new JsonPrimitive("cog"));
                cogMaterial.add("texture", (JsonElement)new JsonPrimitive(this.getCogTexturePath(woodType).toString()));
                sink.addJson(new class_2960("everycomp", "extendedwrenches/wrench_material/" + woodType.getAppendableId() + "_cog"), (JsonElement)cogMaterial, ResType.JSON);
                JsonObject additionItem = new JsonObject();
                additionItem.add("item", (JsonElement)new JsonPrimitive(class_7923.field_41178.method_10221((Object)woodType.planks.method_8389()).toString()));
                JsonObject cogRecipe = new JsonObject();
                cogRecipe.add("type", (JsonElement)new JsonPrimitive("extendedwrenches:wrench_material_swap"));
                cogRecipe.add("addition", (JsonElement)additionItem);
                cogRecipe.add("material", (JsonElement)new JsonPrimitive("everycomp:" + woodType.getAppendableId() + "_cog"));
                cogRecipe.add("part", (JsonElement)new JsonPrimitive("cog"));
                JsonObject cogTemplateItem = new JsonObject();
                cogTemplateItem.add("item", (JsonElement)new JsonPrimitive(class_7923.field_41178.method_10221((Object)((class_1792)ExtendedItems.WRENCH_COG_AUGMENT.get())).toString()));
                cogRecipe.add("template", (JsonElement)cogTemplateItem);
                sink.addJson(new class_2960("everycomp", "wrench/cog/" + woodType.getAppendableId() + "_cog_swap"), (JsonElement)cogRecipe, ResType.RECIPES);
                JsonObject handleMaterial = new JsonObject();
                handleMaterial.add("part", (JsonElement)new JsonPrimitive("handle"));
                handleMaterial.add("texture", (JsonElement)new JsonPrimitive(this.getHandleTexturePath(woodType).toString()));
                sink.addJson(new class_2960("everycomp", "extendedwrenches/wrench_material/" + woodType.getAppendableId() + "_handle"), (JsonElement)handleMaterial, ResType.JSON);
                JsonObject handleRecipe = new JsonObject();
                handleRecipe.add("type", (JsonElement)new JsonPrimitive("extendedwrenches:wrench_material_swap"));
                handleRecipe.add("addition", (JsonElement)additionItem);
                handleRecipe.add("material", (JsonElement)new JsonPrimitive("everycomp:" + woodType.getAppendableId() + "_handle"));
                handleRecipe.add("part", (JsonElement)new JsonPrimitive("handle"));
                JsonObject handleTemplateItem = new JsonObject();
                handleTemplateItem.add("item", (JsonElement)new JsonPrimitive(class_7923.field_41178.method_10221((Object)((class_1792)ExtendedItems.WRENCH_HANDLE_AUGMENT.get())).toString()));
                handleRecipe.add("template", (JsonElement)handleTemplateItem);
                sink.addJson(new class_2960("everycomp", "wrench/handle/" + woodType.getAppendableId() + "_handle_swap"), (JsonElement)handleRecipe, ResType.RECIPES);
            }
        });
    }

    private class_2960 getCogTexturePath(WoodType woodType) {
        return new class_2960("everycomp", "item/extended_wrench/cog_materials/" + woodType.getAppendableId());
    }

    private class_2960 getHandleTexturePath(WoodType woodType) {
        return new class_2960("everycomp", "item/extended_wrench/handle_materials/" + woodType.getAppendableId());
    }
}

