/*
 * Decompiled with CFR 0.152.
 */
package net.vercte.extendedwrenches.wrench;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.wrench.WrenchItem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.vercte.extendedwrenches.ExtendedItems;
import net.vercte.extendedwrenches.wrench.WrenchPart;

public class ExtendedWrenchItem
extends WrenchItem {
    public static final String TAG_DISPLAY = "display";
    public static final String TAG_MATERIALS = "materials";
    public static final String TAG_MATERIAL_LOCATION = "location";
    private static final String TAG_GRIP_COLOR = "grip_color";
    private static final int DEFAULT_GRIP_COLOR = 13061958;

    public ExtendedWrenchItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public static boolean hasCustomColor(class_1799 stack) {
        class_2487 compoundtag = stack.method_7941(TAG_DISPLAY);
        return compoundtag != null && compoundtag.method_10573(TAG_GRIP_COLOR, 99);
    }

    public static int getColor(class_1799 stack) {
        class_2487 display = stack.method_7941(TAG_DISPLAY);
        return display != null && display.method_10573(TAG_GRIP_COLOR, 99) ? display.method_10550(TAG_GRIP_COLOR) : 13061958;
    }

    public static void setColor(class_1799 stack, int color) {
        stack.method_7911(TAG_DISPLAY).method_10569(TAG_GRIP_COLOR, color);
    }

    public static void clearColor(class_1799 stack) {
        class_2487 display = stack.method_7941(TAG_DISPLAY);
        if (display != null) {
            display.method_10551(TAG_GRIP_COLOR);
        }
    }

    public static class_1799 dyeWrench(class_1799 stack, List<class_1769> dyes) {
        class_1799 copiedWrench = class_1799.field_8037;
        int[] color = new int[3];
        int significant = 0;
        int amount = 0;
        class_1792 item = stack.method_7909();
        ExtendedWrenchItem wrench = null;
        if (item instanceof ExtendedWrenchItem) {
            wrench = (ExtendedWrenchItem)item;
            copiedWrench = stack.method_46651(1);
            if (ExtendedWrenchItem.hasCustomColor(stack)) {
                int k = ExtendedWrenchItem.getColor(copiedWrench);
                float wR = (float)(k >> 16 & 0xFF) / 255.0f;
                float wG = (float)(k >> 8 & 0xFF) / 255.0f;
                float wB = (float)(k & 0xFF) / 255.0f;
                significant += (int)Math.max(wR, Math.max(wG, wB)) * 255;
                color[0] = color[0] + (int)(wR * 255.0f);
                color[1] = color[1] + (int)(wG * 255.0f);
                color[2] = color[2] + (int)(wB * 255.0f);
                ++amount;
            }
            for (class_1769 dyeitem : dyes) {
                float[] dyeColors = dyeitem.method_7802().method_7787();
                int dR = (int)(dyeColors[0] * 255.0f);
                int dG = (int)(dyeColors[1] * 255.0f);
                int dB = (int)(dyeColors[2] * 255.0f);
                significant += Math.max(dR, Math.max(dG, dB));
                color[0] = color[0] + dR;
                color[1] = color[1] + dG;
                color[2] = color[2] + dB;
                ++amount;
            }
        }
        if (wrench == null) {
            return class_1799.field_8037;
        }
        int aR = color[0] / amount;
        int aG = color[1] / amount;
        int aB = color[2] / amount;
        float f3 = (float)significant / (float)amount;
        float f4 = Math.max(aR, Math.max(aG, aB));
        aR = (int)((float)aR * f3 / f4);
        aG = (int)((float)aG * f3 / f4);
        aB = (int)((float)aB * f3 / f4);
        int j2 = (aR << 8) + aG;
        j2 = (j2 << 8) + aB;
        ExtendedWrenchItem.setColor(copiedWrench, j2);
        return copiedWrench;
    }

    public static class_1799 swapMaterial(class_1799 stack, class_2960 location, WrenchPart part) {
        class_2487 display = stack.method_7911(TAG_DISPLAY);
        class_2487 materials = display.method_10562(TAG_MATERIALS);
        class_2487 materialData = materials.method_10562(part.method_15434());
        materialData.method_10582(TAG_MATERIAL_LOCATION, location.toString());
        materials.method_10566(part.method_15434(), (class_2520)materialData);
        display.method_10566(TAG_MATERIALS, (class_2520)materials);
        return stack;
    }

    public static boolean hasMaterial(class_1799 stack, WrenchPart part, @Nullable class_2960 material) {
        if (material == null) {
            return false;
        }
        class_2487 display = stack.method_7911(TAG_DISPLAY);
        class_2487 materials = display.method_10562(TAG_MATERIALS);
        class_2487 materialData = materials.method_10562(part.method_15434());
        String materialLocation = materialData.method_10558(TAG_MATERIAL_LOCATION);
        if (materialLocation.isEmpty()) {
            String locString = material.toString();
            if (part == WrenchPart.HEAD && locString.equals("extendedwrenches:gold_head")) {
                return true;
            }
            if (part == WrenchPart.HANDLE && locString.equals("extendedwrenches:dark_oak_handle")) {
                return true;
            }
            if (part == WrenchPart.COG && locString.equals("extendedwrenches:spruce_cog")) {
                return true;
            }
            if (part == WrenchPart.AXIS && locString.equals("extendedwrenches:andesite_axis")) {
                return true;
            }
        }
        return materialLocation.equals(material.toString());
    }

    public static class_1799 convertWrench(class_1799 original) {
        if (original.method_31574((class_1792)AllItems.WRENCH.get())) {
            return ExtendedItems.WRENCH.asStack();
        }
        return original;
    }

    @Nonnull
    public String method_7876() {
        return "item.create.wrench";
    }
}

