/*
 * Decompiled with CFR 0.152.
 */
package net.vercte.extendedwrenches.wrench;

import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueHandler;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.PartialItemModelRenderer;
import com.simibubi.create.foundation.model.BakedModelHelper;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.util.RendererReloadCache;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import java.util.Optional;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.StitchedSprite;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.vercte.extendedwrenches.ExtendedWrenches;
import net.vercte.extendedwrenches.ExtendedWrenchesData;
import net.vercte.extendedwrenches.wrench.WrenchMaterial;
import net.vercte.extendedwrenches.wrench.WrenchPart;
import org.jetbrains.annotations.Nullable;

public class ExtendedWrenchItemRenderer
extends CustomRenderedItemModelRenderer {
    private static final RendererReloadCache<class_2960, class_1058> CACHED_TEXTURES = new RendererReloadCache(ExtendedWrenchItemRenderer::getAtlasSprite);
    private static final RendererReloadCache<class_2960, class_2960> CACHED_MATERIAL_TEXTURE_LOCATIONS = new RendererReloadCache(ExtendedWrenchItemRenderer::getAbsentMaterialTexture);
    public static final StitchedSprite HEAD_TEXTURE = new StitchedSprite(ExtendedWrenches.asResource("item/extended_wrench/head_materials/gold"));
    public static final StitchedSprite HANDLE_TEXTURE = new StitchedSprite(ExtendedWrenches.asResource("item/extended_wrench/handle_materials/dark_oak"));
    public static final StitchedSprite AXIS_TEXTURE = new StitchedSprite(ExtendedWrenches.asResource("item/extended_wrench/axis_materials/andesite"));
    public static final StitchedSprite COG_TEXTURE = new StitchedSprite(ExtendedWrenches.asResource("item/extended_wrench/cog_materials/spruce"));
    protected static final PartialModel GEAR = PartialModel.of((class_2960)ExtendedWrenches.asResource("item/extended_wrench/gear"));

    protected void render(class_1799 stack, CustomRenderedItemModel model, PartialItemModelRenderer renderer, class_811 transformType, class_4587 ms, class_4597 buffer, int light, int overlay) {
        class_2960 headMaterial = ExtendedWrenchItemRenderer.getMaterialTexture(stack, WrenchPart.HEAD);
        class_2960 handleMaterial = ExtendedWrenchItemRenderer.getMaterialTexture(stack, WrenchPart.HANDLE);
        class_2960 cogMaterial = ExtendedWrenchItemRenderer.getMaterialTexture(stack, WrenchPart.COG);
        class_2960 axisMaterial = ExtendedWrenchItemRenderer.getMaterialTexture(stack, WrenchPart.AXIS);
        class_1087 replacedBody = ExtendedWrenchItemRenderer.generateBodyModel(model.getOriginalModel(), headMaterial, handleMaterial, axisMaterial);
        renderer.render(replacedBody, light);
        float xOffset = -0.0625f;
        ms.method_46416(-xOffset, 0.0f, 0.0f);
        ms.method_22907(class_7833.field_40716.rotationDegrees(ScrollValueHandler.getScroll((float)AnimationTickHolder.getPartialTicks())));
        ms.method_46416(xOffset, 0.0f, 0.0f);
        class_1087 replacedCog = ExtendedWrenchItemRenderer.generateCogModel(GEAR.get(), cogMaterial);
        renderer.render(replacedCog, light);
    }

    public static class_1087 generateBodyModel(class_1087 template, @Nullable class_2960 headTexture, @Nullable class_2960 handleTexture, @Nullable class_2960 axisTexture) {
        class_1058 headReplacement = HEAD_TEXTURE.get();
        if (headTexture != null) {
            headReplacement = (class_1058)CACHED_TEXTURES.get((Object)headTexture);
        }
        class_1058 handleReplacement = HANDLE_TEXTURE.get();
        if (handleTexture != null) {
            handleReplacement = (class_1058)CACHED_TEXTURES.get((Object)handleTexture);
        }
        class_1058 axisReplacement = AXIS_TEXTURE.get();
        if (axisTexture != null) {
            axisReplacement = (class_1058)CACHED_TEXTURES.get((Object)axisTexture);
        }
        Reference2ReferenceOpenHashMap map = new Reference2ReferenceOpenHashMap();
        map.put(HEAD_TEXTURE.get(), headReplacement);
        map.put(HANDLE_TEXTURE.get(), handleReplacement);
        map.put(AXIS_TEXTURE.get(), axisReplacement);
        return BakedModelHelper.generateModel((class_1087)template, ((Map)map)::get);
    }

    public static class_1087 generateCogModel(class_1087 template, @Nullable class_2960 cogTexture) {
        class_1058 cogReplacement = COG_TEXTURE.get();
        if (cogTexture != null) {
            cogReplacement = (class_1058)CACHED_TEXTURES.get((Object)cogTexture);
        }
        Reference2ReferenceOpenHashMap map = new Reference2ReferenceOpenHashMap();
        map.put(COG_TEXTURE.get(), cogReplacement);
        return BakedModelHelper.generateModel((class_1087)template, ((Map)map)::get);
    }

    private static class_1058 getAtlasSprite(class_2960 location) {
        return (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(location);
    }

    private static class_2960 getMaterialTexture(class_1799 stack, WrenchPart part) {
        class_2487 display = stack.method_7911("display");
        class_2487 materialTag = display.method_10562("materials");
        String materialLocationStr = materialTag.method_10562(part.method_15434()).method_10558("location");
        if (materialLocationStr.isEmpty()) {
            return null;
        }
        class_2960 materialLocation = new class_2960(materialLocationStr);
        return (class_2960)CACHED_MATERIAL_TEXTURE_LOCATIONS.get((Object)materialLocation);
    }

    @Nullable
    private static class_2960 getAbsentMaterialTexture(class_2960 location) {
        class_5455 access = ExtendedWrenchItemRenderer.getRegistryAccess();
        if (access == null) {
            return null;
        }
        class_2378 materials = access.method_30530(ExtendedWrenchesData.WRENCH_MATERIAL);
        Optional optMaterial = materials.method_17966(location);
        return optMaterial.isPresent() ? ((WrenchMaterial)optMaterial.get()).texture() : null;
    }

    @Nullable
    private static class_5455 getRegistryAccess() {
        class_310 mc = class_310.method_1551();
        class_638 level = mc.field_1687;
        if (level == null) {
            return null;
        }
        return level.method_30349();
    }
}

