/*
 * Decompiled with CFR 0.152.
 */
package net.vercte.extendedwrenches.wrench;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.AllItems;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2444;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_8059;
import net.vercte.extendedwrenches.ExtendedItems;
import net.vercte.extendedwrenches.ExtendedWrenches;
import net.vercte.extendedwrenches.ExtendedWrenchesData;
import net.vercte.extendedwrenches.ExtendedWrenchesRecipeSerializers;
import net.vercte.extendedwrenches.wrench.ExtendedWrenchItem;
import net.vercte.extendedwrenches.wrench.WrenchMaterial;
import net.vercte.extendedwrenches.wrench.WrenchPart;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.NonnullDefault;

public class WrenchMaterialSwapRecipe
implements class_8059 {
    private final class_2960 id;
    private final class_2960 materialLocation;
    final class_1856 template;
    final class_1856 addition;
    final WrenchPart part;

    public WrenchMaterialSwapRecipe(class_2960 id, class_2960 material, class_1856 template, class_1856 addition, WrenchPart part) {
        this.id = id;
        this.materialLocation = material;
        this.template = template;
        this.addition = addition;
        this.part = part;
    }

    public boolean method_48453(@NotNull class_1799 stack) {
        return this.template.method_8093(stack);
    }

    public boolean method_48454(@NotNull class_1799 stack) {
        return stack.method_31574((class_1792)ExtendedItems.WRENCH.get()) || stack.method_31574((class_1792)AllItems.WRENCH.get());
    }

    public boolean method_30029(@NotNull class_1799 stack) {
        return this.addition.method_8093(stack);
    }

    public class_1856 getTemplate() {
        return this.template;
    }

    public class_1856 getBase() {
        return class_1856.method_8091((class_1935[])new class_1935[]{AllItems.WRENCH, ExtendedItems.WRENCH});
    }

    public class_1856 getAddition() {
        return this.addition;
    }

    public boolean method_8115(@NotNull class_1263 container, @NotNull class_1937 level) {
        class_1799 template = container.method_5438(0);
        class_1799 addition = container.method_5438(2);
        class_1799 stack = container.method_5438(1);
        boolean isWrench = stack.method_31574((class_1792)ExtendedItems.WRENCH.get()) || stack.method_31574((class_1792)AllItems.WRENCH.get());
        return isWrench && this.template.method_8093(template) && this.addition.method_8093(addition) && !ExtendedWrenchItem.hasMaterial(stack, this.part, this.materialLocation);
    }

    @NotNull
    public class_1799 method_8116(@NotNull class_1263 container, @NotNull class_5455 access) {
        return this.applyTransformation(container.method_5438(1), access);
    }

    public class_1799 applyTransformation(class_1799 input, @NotNull class_5455 access) {
        class_2378 materials = access.method_30530(ExtendedWrenchesData.WRENCH_MATERIAL);
        Optional optMaterial = materials.method_17966(this.materialLocation);
        if (optMaterial.isEmpty()) {
            return class_1799.field_8037;
        }
        class_1799 wrench = ExtendedWrenchItem.convertWrench(input);
        WrenchMaterial material = (WrenchMaterial)optMaterial.get();
        class_2960 materialLocation = materials.method_10221((Object)material);
        assert (materialLocation != null);
        return ExtendedWrenchItem.swapMaterial(wrench.method_7972(), materialLocation, this.part);
    }

    @NotNull
    public class_1799 method_8110(@NotNull class_5455 access) {
        return ExtendedItems.WRENCH.asStack();
    }

    @NotNull
    public class_2960 method_8114() {
        return this.id;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return ExtendedWrenchesRecipeSerializers.WRENCH_MATERIAL_SWAP;
    }

    public static class Builder
    implements class_2444 {
        private final class_2960 id;
        private class_2960 materialLocation;
        private class_1856 template;
        private class_1856 addition;
        private WrenchPart part;

        public Builder(class_2960 id) {
            this.id = id;
        }

        public Builder material(String id) {
            this.materialLocation = ExtendedWrenches.asResource(id);
            return this;
        }

        public Builder template(class_1935 template) {
            this.template = class_1856.method_8091((class_1935[])new class_1935[]{template});
            return this;
        }

        public Builder addition(class_6862<class_1792> addition) {
            return this.addition(class_1856.method_8106(addition));
        }

        public Builder addition(class_1935 addition) {
            return this.addition(class_1856.method_8091((class_1935[])new class_1935[]{addition}));
        }

        public Builder addition(class_1856 addition) {
            this.addition = addition;
            return this;
        }

        public Builder part(WrenchPart part) {
            this.part = part;
            return this;
        }

        public void save(Consumer<class_2444> consumer) {
            consumer.accept(this);
        }

        public void method_10416(JsonObject json) {
            json.addProperty("material", this.materialLocation.toString());
            json.add("template", this.template.method_8089());
            json.add("addition", this.addition.method_8089());
            json.addProperty("part", this.part.method_15434());
        }

        @NotNull
        public class_2960 method_10417() {
            return this.id;
        }

        @NotNull
        public class_1865<?> method_17800() {
            return ExtendedWrenchesRecipeSerializers.WRENCH_MATERIAL_SWAP;
        }

        public JsonObject method_10415() {
            return null;
        }

        public class_2960 method_10418() {
            return null;
        }
    }

    @NonnullDefault
    public static class Serializer
    implements class_1865<WrenchMaterialSwapRecipe> {
        public WrenchMaterialSwapRecipe fromJson(class_2960 location, JsonObject json) {
            class_1856 base = class_1856.method_52177((JsonElement)class_3518.method_52226((JsonObject)json, (String)"template"));
            class_1856 addition = class_1856.method_52177((JsonElement)class_3518.method_52226((JsonObject)json, (String)"addition"));
            class_2960 materialLocation = class_2960.method_12829((String)class_3518.method_15265((JsonObject)json, (String)"material"));
            WrenchPart part = WrenchPart.getFromString(class_3518.method_15265((JsonObject)json, (String)"part"));
            return new WrenchMaterialSwapRecipe(location, materialLocation, base, addition, part);
        }

        public WrenchMaterialSwapRecipe fromNetwork(class_2960 location, class_2540 buffer) {
            class_1856 template = class_1856.method_8086((class_2540)buffer);
            class_1856 addition = class_1856.method_8086((class_2540)buffer);
            class_2960 materialLocation = buffer.method_10810();
            String part = buffer.method_19772();
            return new WrenchMaterialSwapRecipe(location, materialLocation, template, addition, WrenchPart.getFromString(part));
        }

        public void toNetwork(class_2540 buffer, WrenchMaterialSwapRecipe recipe) {
            recipe.template.method_8088(buffer);
            recipe.addition.method_8088(buffer);
            buffer.method_10812(recipe.materialLocation);
            buffer.method_10814(recipe.part.method_15434());
        }
    }
}

