/*
 * Decompiled with CFR 0.152.
 */
package net.vercte.extendedwrenches;

import com.mojang.logging.LogUtils;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.vercte.extendedwrenches.ExtendedItems;
import net.vercte.extendedwrenches.ExtendedWrenchesData;
import net.vercte.extendedwrenches.ExtendedWrenchesRecipeSerializers;
import net.vercte.extendedwrenches.compat.ModCompat;
import org.slf4j.Logger;

@Mod(value="extendedwrenches")
public class ExtendedWrenches {
    public static final String ID = "extendedwrenches";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final CreateRegistrate REGISTRATE = ((CreateRegistrate)CreateRegistrate.create((String)"extendedwrenches").defaultCreativeTab((ResourceKey)null)).setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));

    public ExtendedWrenches(IEventBus modEventBus) {
        ExtendedItems.init();
        ExtendedWrenchesData.register(modEventBus);
        ExtendedWrenches.everyCompatModule();
        modEventBus.addListener(ExtendedWrenches::initExtra);
        modEventBus.addListener(ExtendedItems::addToCreative);
        modEventBus.addListener(ExtendedWrenchesData::registerDatapackRegistries);
        modEventBus.addListener(EventPriority.HIGHEST, ExtendedWrenchesData::gatherRegistrateData);
        modEventBus.addListener(EventPriority.LOWEST, ExtendedWrenchesData::gatherData);
        ExtendedWrenchesRecipeSerializers.register(modEventBus);
        REGISTRATE.registerEventListeners(modEventBus);
    }

    public static void initExtra(FMLCommonSetupEvent event) {
        CauldronInteraction.WATER.map().put((Item)ExtendedItems.WRENCH.get(), CauldronInteraction.DYED_ITEM);
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }

    private static void everyCompatModule() {
        try {
            if (ModList.get().isLoaded("everycomp")) {
                ModCompat.init();
                LOGGER.debug("Every Compat found, starting compatibility");
            } else {
                LOGGER.debug("Every Compat is not installed");
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to start EveryComp module", (Throwable)e);
        }
    }
}

