/*
 * Decompiled with CFR 0.152.
 */
package net.vercte.extendedwrenches.compat.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.vercte.extendedwrenches.ExtendedWrenches;
import net.vercte.extendedwrenches.compat.jei.WrenchSmithingCategory;
import net.vercte.extendedwrenches.wrench.WrenchMaterialSwapRecipe;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class ExtendedJEI
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return ExtendedWrenches.asResource("default");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new WrenchSmithingCategory()});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(WrenchSmithingCategory.RECIPE_TYPE, this.getAllSwapRecipes());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalysts(WrenchSmithingCategory.RECIPE_TYPE, new ItemLike[]{Blocks.SMITHING_TABLE});
    }

    public List<WrenchMaterialSwapRecipe> getAllSwapRecipes() {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        assert (level != null);
        ArrayList<WrenchMaterialSwapRecipe> recipes = new ArrayList<WrenchMaterialSwapRecipe>();
        Stream smithingRecipeStream = level.getRecipeManager().getAllRecipesFor(RecipeType.SMITHING).stream();
        smithingRecipeStream.forEach(r -> {
            Recipe patt0$temp = r.value();
            if (patt0$temp instanceof WrenchMaterialSwapRecipe) {
                WrenchMaterialSwapRecipe sr = (WrenchMaterialSwapRecipe)patt0$temp;
                recipes.add(sr);
            }
        });
        return recipes;
    }
}

