/*
 * Decompiled with CFR 0.152.
 */
package net.vercte.extendedwrenches.wrench;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.AllItems;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.vercte.extendedwrenches.ExtendedItems;
import net.vercte.extendedwrenches.ExtendedWrenches;
import net.vercte.extendedwrenches.ExtendedWrenchesData;
import net.vercte.extendedwrenches.ExtendedWrenchesRecipeSerializers;
import net.vercte.extendedwrenches.wrench.ExtendedWrenchItem;
import net.vercte.extendedwrenches.wrench.WrenchMaterial;
import net.vercte.extendedwrenches.wrench.WrenchPart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrenchMaterialSwapRecipe
implements SmithingRecipe {
    private final ResourceLocation materialLocation;
    final Ingredient template;
    final Ingredient addition;
    final WrenchPart part;

    public WrenchMaterialSwapRecipe(ResourceLocation material, Ingredient template, Ingredient addition, WrenchPart part) {
        this.materialLocation = material;
        this.template = template;
        this.addition = addition;
        this.part = part;
    }

    public boolean isTemplateIngredient(@NotNull ItemStack stack) {
        return this.template.test(stack);
    }

    public boolean isBaseIngredient(@NotNull ItemStack stack) {
        return stack.is((Item)ExtendedItems.WRENCH.get()) || stack.is((Item)AllItems.WRENCH.get());
    }

    public boolean isAdditionIngredient(@NotNull ItemStack stack) {
        return this.addition.test(stack);
    }

    public ResourceLocation getMaterialLocation() {
        return this.materialLocation;
    }

    public Ingredient getTemplate() {
        return this.template;
    }

    public Ingredient getBase() {
        return Ingredient.of((ItemLike[])new ItemLike[]{AllItems.WRENCH, ExtendedItems.WRENCH});
    }

    public Ingredient getAddition() {
        return this.addition;
    }

    public WrenchPart getPart() {
        return this.part;
    }

    public boolean matches(@NotNull SmithingRecipeInput input, @NotNull Level level) {
        ItemStack template = input.getItem(0);
        ItemStack addition = input.getItem(2);
        ItemStack stack = input.getItem(1);
        boolean isWrench = stack.is((Item)ExtendedItems.WRENCH.get()) || stack.is((Item)AllItems.WRENCH.get());
        return isWrench && this.template.test(template) && this.addition.test(addition) && !ExtendedWrenchItem.hasMaterial(stack, this.part, this.materialLocation);
    }

    @NotNull
    public ItemStack assemble(@NotNull SmithingRecipeInput input, @NotNull HolderLookup.Provider provider) {
        ResourceKey materialKey = ResourceKey.create(ExtendedWrenchesData.WRENCH_MATERIAL, (ResourceLocation)this.materialLocation);
        HolderLookup.RegistryLookup materials = provider.lookupOrThrow(ExtendedWrenchesData.WRENCH_MATERIAL);
        Optional optMaterial = materials.get(materialKey);
        if (optMaterial.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack wrench = ExtendedWrenchItem.convertWrench(input.getItem(1));
        return ExtendedWrenchItem.swapMaterial(wrench, this.part, (Holder<WrenchMaterial>)((Holder)optMaterial.get()));
    }

    public ItemStack applyTransformation(ItemStack original, @NotNull HolderLookup<WrenchMaterial> materials) {
        ResourceKey materialKey = ResourceKey.create(ExtendedWrenchesData.WRENCH_MATERIAL, (ResourceLocation)this.materialLocation);
        Optional optMaterial = materials.get(materialKey);
        if (optMaterial.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return ExtendedWrenchItem.swapMaterial(original, this.part, (Holder<WrenchMaterial>)((Holder)optMaterial.get()));
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider provider) {
        return ExtendedItems.WRENCH.asStack();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return ExtendedWrenchesRecipeSerializers.WRENCH_MATERIAL_SWAP.get();
    }

    public static class Builder
    implements RecipeBuilder {
        private final ResourceLocation id;
        private ResourceLocation materialLocation;
        private Ingredient template;
        private Ingredient addition;
        private WrenchPart part;

        public Builder(ResourceLocation id) {
            this.id = id;
        }

        public Builder material(String id) {
            this.materialLocation = ExtendedWrenches.asResource(id);
            return this;
        }

        public Builder template(ItemLike template) {
            this.template = Ingredient.of((ItemLike[])new ItemLike[]{template});
            return this;
        }

        public Builder addition(TagKey<Item> addition) {
            return this.addition(Ingredient.of(addition));
        }

        public Builder addition(ItemLike addition) {
            return this.addition(Ingredient.of((ItemLike[])new ItemLike[]{addition}));
        }

        public Builder addition(Ingredient addition) {
            this.addition = addition;
            return this;
        }

        public Builder part(WrenchPart part) {
            this.part = part;
            return this;
        }

        @NotNull
        public RecipeBuilder unlockedBy(@NotNull String name, @NotNull Criterion<?> criterion) {
            return this;
        }

        @NotNull
        public RecipeBuilder group(@Nullable String s) {
            return this;
        }

        @NotNull
        public Item getResult() {
            return ExtendedItems.WRENCH.asItem();
        }

        public void save(@NotNull RecipeOutput output, @NotNull ResourceLocation location) {
            Advancement.Builder advancement = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)this.id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)this.id)).requirements(AdvancementRequirements.Strategy.OR);
            WrenchMaterialSwapRecipe recipe = new WrenchMaterialSwapRecipe(this.materialLocation, this.template, this.addition, this.part);
            output.accept(location, (Recipe)recipe, advancement.build(this.id.withPrefix("recipes/")));
        }

        public void save(@NotNull RecipeOutput output) {
            this.save(output, this.id);
        }
    }

    public static class Serializer
    implements RecipeSerializer<WrenchMaterialSwapRecipe> {
        public static final MapCodec<WrenchMaterialSwapRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)ResourceLocation.CODEC.fieldOf("material").forGetter(WrenchMaterialSwapRecipe::getMaterialLocation), (App)Ingredient.CODEC.fieldOf("template").forGetter(WrenchMaterialSwapRecipe::getTemplate), (App)Ingredient.CODEC.fieldOf("addition").forGetter(WrenchMaterialSwapRecipe::getAddition), (App)StringRepresentable.fromEnum(WrenchPart::values).fieldOf("part").forGetter(WrenchMaterialSwapRecipe::getPart)).apply((Applicative)inst, WrenchMaterialSwapRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, WrenchMaterialSwapRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, WrenchMaterialSwapRecipe::getMaterialLocation, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, WrenchMaterialSwapRecipe::getTemplate, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, WrenchMaterialSwapRecipe::getAddition, (StreamCodec)ByteBufCodecs.idMapper(WrenchPart.BY_ID, WrenchPart::getId), WrenchMaterialSwapRecipe::getPart, WrenchMaterialSwapRecipe::new);

        @NotNull
        public MapCodec<WrenchMaterialSwapRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, WrenchMaterialSwapRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

